/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.consolidate;

import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.dos.OHLCVItemExtended;
import de.gsi.financial.samples.dos.PriceVolumeContainer;
import de.gsi.financial.samples.service.consolidate.AbstractIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.IncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.RangeBarsIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.TimePeriodIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.VolumeIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OhlcvTimeframeConsolidation {
    private OhlcvTimeframeConsolidation() {
    }

    public static IncrementalOhlcvConsolidation createConsolidation(IntradayPeriod intradayPeriod, Interval<Calendar> tt, Map<String, OhlcvConsolidationAddon[]> addons) {
        AbstractIncrementalOhlcvConsolidation consolidation = null;
        OhlcvConsolidationComputation ohlcvConsolidationComputation = intradayPeriod.isExtendedCalculation() ? new ExtendedOhlcvConsolidationComputation() : new StandardOhlcvConsolidationComputation();
        OhlcvConsolidationAddon[] _ohlcvConsolidationAddons = null;
        if (intradayPeriod.getCalculationAddonServicesType() != null && addons != null) {
            _ohlcvConsolidationAddons = addons.get(intradayPeriod.getCalculationAddonServicesType());
        }
        switch (intradayPeriod.getPeriod()) {
            case RB: {
                consolidation = new RangeBarsIncrementalOhlcvConsolidation(ohlcvConsolidationComputation, intradayPeriod, intradayPeriod.getMinimalMoveSymbol(), tt, _ohlcvConsolidationAddons);
                break;
            }
            case V: {
                consolidation = new VolumeIncrementalOhlcvConsolidation(ohlcvConsolidationComputation, intradayPeriod, tt, _ohlcvConsolidationAddons);
                break;
            }
            case T: {
                break;
            }
            case H: {
                throw new IllegalArgumentException("HOUR timeframe is not allowed for tick data provider.");
            }
            default: {
                consolidation = new TimePeriodIncrementalOhlcvConsolidation(ohlcvConsolidationComputation, intradayPeriod, tt, _ohlcvConsolidationAddons);
            }
        }
        return consolidation;
    }

    public static class ExtendedOhlcvConsolidationComputation
    implements OhlcvConsolidationComputation {
        @Override
        public OHLCVItem consolidate(Date timeStamp, OHLCVItem lastConsolidatedItem, OHLCVItem incrementItem) {
            return this.consolidate(timeStamp, lastConsolidatedItem, incrementItem, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OHLCVItem consolidate(Date timestamp, OHLCVItem lastConsolidatedItem, OHLCVItem incrementItem, boolean computePullbackColumn) {
            double oi = 0.0;
            double volume = lastConsolidatedItem.getVolume();
            double volumeUp = lastConsolidatedItem.getVolumeUpAsk();
            double volumeDown = lastConsolidatedItem.getVolumeDownBid();
            double open = lastConsolidatedItem.getOpen();
            double close = incrementItem.getClose();
            double low = lastConsolidatedItem.getLow();
            double high = lastConsolidatedItem.getHigh();
            OHLCVItemExtended ohlcvItemExtended = lastConsolidatedItem.getExtended();
            if (ohlcvItemExtended == null) {
                ohlcvItemExtended = new OHLCVItemExtended();
            }
            Object object = ohlcvItemExtended.lock;
            synchronized (object) {
                ohlcvItemExtended.setLastIncrementItem(incrementItem);
                PriceVolumeContainer priceVolumeContainer = ohlcvItemExtended.getPriceVolumeContainer();
                OHLCVItem pullbackOhlcvItem = ohlcvItemExtended.getPullbackOhlcvItem();
                if (incrementItem.getLow() < low) {
                    low = incrementItem.getLow();
                    if (computePullbackColumn) {
                        pullbackOhlcvItem = new OHLCVItem(timestamp, low, low, low, low, 0.0, 0.0, 0.0, 0.0);
                        ohlcvItemExtended.setPullbackOhlcvItem(pullbackOhlcvItem);
                    }
                }
                if (incrementItem.getHigh() > high) {
                    high = incrementItem.getHigh();
                    if (computePullbackColumn) {
                        pullbackOhlcvItem = new OHLCVItem(timestamp, high, high, high, high, 0.0, 0.0, 0.0, 0.0);
                        ohlcvItemExtended.setPullbackOhlcvItem(pullbackOhlcvItem);
                    }
                }
                if (pullbackOhlcvItem != null) {
                    OHLCVItem pullbackOhlcvItemUpdated = this.consolidate(timestamp, pullbackOhlcvItem, incrementItem, false);
                    ohlcvItemExtended.setPullbackOhlcvItem(pullbackOhlcvItemUpdated);
                }
                priceVolumeContainer.addPriceVolume(incrementItem.getClose(), incrementItem.getVolumeDownBid(), incrementItem.getVolumeUpAsk());
            }
            OHLCVItem ohlcvItem = new OHLCVItem(timestamp, open, high, low, close, volume += incrementItem.getVolume(), oi, volumeUp += incrementItem.getVolumeUpAsk(), volumeDown += incrementItem.getVolumeDownBid());
            ohlcvItemExtended.setTimestamp(timestamp);
            ohlcvItem.setExtended(ohlcvItemExtended);
            return ohlcvItem;
        }

        @Override
        public OHLCVItem consolidate(List<OHLCVItem> ohlcvItems) {
            return this.consolidate(null, ohlcvItems);
        }

        @Override
        public OHLCVItem consolidate(Date timestamp, List<OHLCVItem> ohlcvItems) {
            if (timestamp == null) {
                timestamp = ohlcvItems.get(0).getTimeStamp();
            }
            double volume = 0.0;
            double volumeUp = 0.0;
            double volumeDown = 0.0;
            double oi = 0.0;
            double open = ohlcvItems.get(0).getOpen();
            double close = ohlcvItems.get(ohlcvItems.size() - 1).getClose();
            double low = Double.MAX_VALUE;
            double high = -1.7976931348623157E308;
            OHLCVItemExtended ohlcvItemExtended = new OHLCVItemExtended();
            PriceVolumeContainer priceVolumeContainer = ohlcvItemExtended.getPriceVolumeContainer();
            for (OHLCVItem ohlcvItem : ohlcvItems) {
                if (ohlcvItem.getLow() < low) {
                    low = ohlcvItem.getLow();
                }
                if (ohlcvItem.getHigh() > high) {
                    high = ohlcvItem.getHigh();
                }
                volume += ohlcvItem.getVolume();
                volumeUp += ohlcvItem.getVolumeUpAsk();
                volumeDown += ohlcvItem.getVolumeDownBid();
                priceVolumeContainer.addPriceVolume(ohlcvItem.getClose(), ohlcvItem.getVolumeDownBid(), ohlcvItem.getVolumeUpAsk());
            }
            OHLCVItem ohlcvItem = new OHLCVItem(timestamp, open, high, low, close, volume, oi, volumeUp, volumeDown);
            ohlcvItemExtended.setTimestamp(timestamp);
            ohlcvItem.setExtended(ohlcvItemExtended);
            return ohlcvItem;
        }
    }

    public static class StandardOhlcvConsolidationComputation
    implements OhlcvConsolidationComputation {
        @Override
        public OHLCVItem consolidate(Date timeStamp, OHLCVItem lastConsolidatedItem, OHLCVItem incrementItem) {
            double oi = 0.0;
            double volume = lastConsolidatedItem.getVolume();
            double low = lastConsolidatedItem.getLow();
            double high = lastConsolidatedItem.getHigh();
            if (incrementItem.getLow() < low) {
                low = incrementItem.getLow();
            }
            if (incrementItem.getHigh() > high) {
                high = incrementItem.getHigh();
            }
            return new OHLCVItem(timeStamp, lastConsolidatedItem.getOpen(), high, low, incrementItem.getClose(), volume += incrementItem.getVolume(), oi);
        }

        @Override
        public OHLCVItem consolidate(List<OHLCVItem> ohlcvItems) {
            return this.consolidate(null, ohlcvItems);
        }

        @Override
        public OHLCVItem consolidate(Date timestamp, List<OHLCVItem> ohlcvItems) {
            if (timestamp == null) {
                timestamp = ohlcvItems.get(0).getTimeStamp();
            }
            double volume = 0.0;
            double oi = 0.0;
            double open = ohlcvItems.get(0).getOpen();
            double close = ohlcvItems.get(ohlcvItems.size() - 1).getClose();
            double low = Double.MAX_VALUE;
            double high = -1.7976931348623157E308;
            for (OHLCVItem ohlcvItem : ohlcvItems) {
                if (ohlcvItem.getLow() < low) {
                    low = ohlcvItem.getLow();
                }
                if (ohlcvItem.getHigh() > high) {
                    high = ohlcvItem.getHigh();
                }
                volume += ohlcvItem.getVolume();
            }
            return new OHLCVItem(timestamp, open, high, low, close, volume, oi);
        }
    }

    public static interface OhlcvConsolidationComputation {
        public OHLCVItem consolidate(List<OHLCVItem> var1);

        public OHLCVItem consolidate(Date var1, List<OHLCVItem> var2);

        public OHLCVItem consolidate(Date var1, OHLCVItem var2, OHLCVItem var3);
    }
}

