/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.consolidate;

import de.gsi.financial.samples.dos.DefaultOHLCV;
import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.consolidate.IncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.OhlcvTimeframeConsolidation;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.util.Calendar;

public abstract class AbstractIncrementalOhlcvConsolidation
implements IncrementalOhlcvConsolidation {
    protected IntradayPeriod period;
    protected OhlcvTimeframeConsolidation.OhlcvConsolidationComputation consolidationComputation;
    protected OhlcvConsolidationAddon[] ohlcvConsolidationAddons;
    protected Interval<Calendar> tt;
    private OHLCVItem lastItem;

    public AbstractIncrementalOhlcvConsolidation(OhlcvTimeframeConsolidation.OhlcvConsolidationComputation consolidationComputation, IntradayPeriod period, Interval<Calendar> tt, OhlcvConsolidationAddon[] ohlcvConsolidationAddons) {
        this.period = period;
        this.consolidationComputation = consolidationComputation == null ? new OhlcvTimeframeConsolidation.StandardOhlcvConsolidationComputation() : consolidationComputation;
        this.ohlcvConsolidationAddons = ohlcvConsolidationAddons;
        this.tt = tt;
    }

    @Override
    public IntradayPeriod getPeriod() {
        return this.period;
    }

    @Override
    public DefaultOHLCV consolidate(DefaultOHLCV ohlcv, OHLCVItem incrementItem) {
        if (this.lastItem == null) {
            this.lastItem = incrementItem;
        }
        if (this.checkConsolidationCondition(this.lastItem, incrementItem)) {
            OHLCVItem finalItem = this.processConsolidation(this.lastItem, incrementItem);
            ohlcv.updateOhlcvItem(ohlcv.size() - 1, finalItem);
            this.lastItem = finalItem;
            this.defineConsolidationConditionAfterUpdate(this.lastItem);
            this.processConsolidationAddonsInUpdate(ohlcv, incrementItem);
        } else {
            ohlcv.addOhlcvItem(incrementItem);
            this.lastItem = incrementItem;
            this.defineConsolidationConditionAfterAddition(this.lastItem);
            this.processConsolidationAddonsInAddition(ohlcv, incrementItem);
        }
        return ohlcv;
    }

    protected void processConsolidationAddonsInUpdate(DefaultOHLCV ohlcv, OHLCVItem incrementItem) {
        if (this.ohlcvConsolidationAddons != null) {
            for (int i = 0; i < this.ohlcvConsolidationAddons.length; ++i) {
                if (!this.ohlcvConsolidationAddons[i].isDynamic()) continue;
                this.ohlcvConsolidationAddons[i].consolidationUpdateAddon(ohlcv, incrementItem);
            }
        }
    }

    protected void processConsolidationAddonsInAddition(DefaultOHLCV ohlcv, OHLCVItem incrementItem) {
        if (this.ohlcvConsolidationAddons != null) {
            for (int i = 0; i < this.ohlcvConsolidationAddons.length; ++i) {
                this.ohlcvConsolidationAddons[i].consolidationAdditionAddon(ohlcv, incrementItem);
            }
        }
    }

    protected abstract void defineConsolidationConditionAfterAddition(OHLCVItem var1);

    protected abstract void defineConsolidationConditionAfterUpdate(OHLCVItem var1);

    protected abstract boolean checkConsolidationCondition(OHLCVItem var1, OHLCVItem var2);

    protected OHLCVItem processConsolidation(OHLCVItem lastItem, OHLCVItem incrementItem) {
        return this.consolidationComputation.consolidate(lastItem.getTimeStamp(), lastItem, incrementItem);
    }
}

