/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.addon;

import de.gsi.financial.samples.dos.AbsorptionClusterDO;
import de.gsi.financial.samples.dos.DefaultOHLCV;
import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.dos.PriceVolumeContainer;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import java.util.NavigableMap;

public class AbsorptionConsolidationAddon
implements OhlcvConsolidationAddon {
    private final boolean searchDynamic;
    private final int absorptionLevel;
    private final int absorptionCluster;
    private final double searchBarPercent;
    private final double extremeAbsorptionLevelParam;

    public AbsorptionConsolidationAddon(boolean searchDynamic, int absorptionLevel, int absorptionCluster, double searchBarPercent, double extremeAbsorptionLevelParam) {
        this.searchDynamic = searchDynamic;
        this.absorptionLevel = absorptionLevel;
        this.absorptionCluster = absorptionCluster;
        this.searchBarPercent = searchBarPercent;
        this.extremeAbsorptionLevelParam = extremeAbsorptionLevelParam;
    }

    @Override
    public DefaultOHLCV consolidationUpdateAddon(DefaultOHLCV ohlcv, OHLCVItem incrementItem) {
        return ohlcv;
    }

    @Override
    public DefaultOHLCV consolidationAdditionAddon(DefaultOHLCV ohlcv, OHLCVItem incrementItem) {
        if (ohlcv.size() < 2) {
            return ohlcv;
        }
        OHLCVItem lastBarItem = ohlcv.getBackOhlcvItem(1);
        this.findClusters(lastBarItem);
        return ohlcv;
    }

    @Override
    public boolean isDynamic() {
        return this.searchDynamic;
    }

    protected void findClusters(OHLCVItem barItem) {
        if (barItem.getExtended() == null) {
            return;
        }
        AbsorptionClusterDO absorptionClusterDO = new AbsorptionClusterDO();
        this.findClustersOfSide(barItem, true, absorptionClusterDO);
        this.findClustersOfSide(barItem, false, absorptionClusterDO);
        barItem.getExtended().setAbsorptionClusterDO(absorptionClusterDO);
    }

    protected void findClustersOfSide(OHLCVItem barItem, boolean bidOrAsk, AbsorptionClusterDO absorptionClusterDO) {
        PriceVolumeContainer priceVolumeContainer = barItem.getExtended().getPriceVolumeContainer();
        NavigableMap<Double, Double[]> map = bidOrAsk ? priceVolumeContainer.getCompletedPriceVolumeTreeMap() : priceVolumeContainer.getCompletedPriceVolumeTreeMap().descendingMap();
        double length = barItem.getHigh() - barItem.getLow();
        double maxPriceBid = length * this.searchBarPercent + barItem.getLow();
        double minPriceAsk = barItem.getHigh() - length * this.searchBarPercent;
        boolean clusterDetected = false;
        double val1 = -1.0;
        double val2 = -1.0;
        int clusterActiveLength = 0;
        boolean firstTime = false;
        for (Double[] priceVolume : map.values()) {
            boolean inrange;
            double volume = bidOrAsk ? priceVolume[1] : priceVolume[2];
            boolean bl = firstTime || (bidOrAsk ? priceVolume[0] <= maxPriceBid : priceVolume[0] >= minPriceAsk) ? true : (inrange = false);
            if (volume >= (double)this.absorptionLevel && inrange) {
                if (clusterActiveLength == 0) {
                    val1 = priceVolume[0];
                    firstTime = true;
                }
                ++clusterActiveLength;
            } else {
                clusterActiveLength = 0;
                firstTime = false;
                if (clusterDetected) break;
            }
            if (clusterActiveLength < this.absorptionCluster) continue;
            clusterDetected = true;
            val2 = priceVolume[0];
        }
        if (clusterDetected) {
            if (bidOrAsk) {
                absorptionClusterDO.addBidCluster(new Interval<Double>(val2, val1));
            } else {
                absorptionClusterDO.addAskCluster(new Interval<Double>(val1, val2));
            }
        } else {
            val1 = -1.0;
            val2 = -1.0;
            clusterActiveLength = 0;
            firstTime = false;
            double extremAbsorptionLevel = 0.0;
            for (Double[] priceVolume : map.values()) {
                double volume = bidOrAsk ? priceVolume[1] : priceVolume[2];
                extremAbsorptionLevel += volume;
            }
            extremAbsorptionLevel /= (double)map.size();
            for (Double[] priceVolume : map.values()) {
                boolean inrange;
                double volume = bidOrAsk ? priceVolume[1] : priceVolume[2];
                boolean bl = firstTime || (bidOrAsk ? priceVolume[0] <= maxPriceBid : priceVolume[0] >= minPriceAsk) ? true : (inrange = false);
                if (volume - extremAbsorptionLevel >= this.extremeAbsorptionLevelParam && inrange) {
                    if (clusterActiveLength == 0) {
                        val1 = priceVolume[0];
                        firstTime = true;
                    }
                    ++clusterActiveLength;
                } else {
                    clusterActiveLength = 0;
                    firstTime = false;
                    if (clusterDetected) break;
                }
                if (clusterActiveLength < 1) continue;
                clusterDetected = true;
                val2 = priceVolume[0];
            }
            if (clusterDetected) {
                if (bidOrAsk) {
                    absorptionClusterDO.addBidCluster(new Interval<Double>(val2, val1));
                } else {
                    absorptionClusterDO.addAskCluster(new Interval<Double>(val1, val2));
                }
            }
        }
    }
}

