/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service;

import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModelAware;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import de.gsi.financial.samples.dos.DefaultOHLCV;
import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.OhlcvChangeListener;
import de.gsi.financial.samples.service.SCIDByNio;
import de.gsi.financial.samples.service.TickDataFinishedException;
import de.gsi.financial.samples.service.TickOhlcvDataProvider;
import de.gsi.financial.samples.service.consolidate.IncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.OhlcvTimeframeConsolidation;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleOhlcvReplayDataSet
extends OhlcvDataSet
implements Iterable<IOhlcvItem>,
IOhlcvItemAware,
AttributeModelAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleOhlcvReplayDataSet.class);
    private static final String DATA_SOURCE_OHLC_TICK = "NQ-201609-GLOBEX";
    private static final String DATA_SOURCE_PATH = "chartfx-samples/target/classes/de/gsi/chart/samples/financial/%s.scid";
    private final transient DoubleProperty replayMultiply = new SimpleDoubleProperty((Object)this, "replayMultiply", 1.0);
    private DataInput inputSource = DataInput.OHLC_TICK;
    private String resource;
    protected transient DefaultOHLCV ohlcv;
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected AtomicBoolean paused = new AtomicBoolean(false);
    protected final transient Object pauseSemaphore = new Object();
    protected transient SCIDByNio scid;
    protected transient TickOhlcvDataProvider tickOhlcvDataProvider;
    protected transient IncrementalOhlcvConsolidation consolidation;
    protected transient Set<OhlcvChangeListener> ohlcvChangeListeners = new LinkedHashSet<OhlcvChangeListener>();
    protected int maxXIndex = 0;

    public SimpleOhlcvReplayDataSet(DataInput dataInput, IntradayPeriod period, Interval<Calendar> timeRange, Interval<Calendar> tt, Calendar replayFrom, Map<String, OhlcvConsolidationAddon[]> addons) {
        super(dataInput.name());
        this.setInputSource(dataInput);
        this.fillTestData(period, timeRange, tt, replayFrom, addons);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)SimpleOhlcvReplayDataSet.class.getSimpleName()).log("started '{}'");
        }
    }

    public void addOhlcvChangeListener(OhlcvChangeListener ohlcvChangeListener) {
        this.ohlcvChangeListeners.add(ohlcvChangeListener);
    }

    public void fillTestData(IntradayPeriod period, Interval<Calendar> timeRange, Interval<Calendar> tt, Calendar replayFrom, Map<String, OhlcvConsolidationAddon[]> addons) {
        this.lock().writeLockGuard(() -> {
            try {
                if (this.getInputSource() == DataInput.OHLC_TICK) {
                    this.resource = DATA_SOURCE_OHLC_TICK;
                }
                this.scid = new SCIDByNio();
                this.scid.openNewChannel(String.format(DATA_SOURCE_PATH, this.resource));
                this.tickOhlcvDataProvider = this.scid.createTickDataReplayStream(timeRange, replayFrom.getTime(), this.replayMultiply);
                this.ohlcv = new DefaultOHLCV();
                this.ohlcv.setTitle(this.resource);
                this.consolidation = OhlcvTimeframeConsolidation.createConsolidation(period, tt, addons);
                this.autoNotification().set(false);
                this.setData(this.ohlcv);
                this.tick();
                this.autoNotification().set(true);
            }
            catch (TickDataFinishedException e) {
                LOGGER.info(e.getMessage());
            }
            catch (ClosedChannelException e) {
                LOGGER.info("The ticker resource was closed already.");
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        });
    }

    protected void tick() throws Exception {
        OHLCVItem increment = this.tickOhlcvDataProvider.get();
        this.consolidation.consolidate(this.ohlcv, increment);
        if (this.maxXIndex < this.ohlcv.size()) {
            this.maxXIndex = this.ohlcv.size();
            this.getAxisDescription(0).set(this.get(0, 0), this.get(0, this.maxXIndex - 1));
        }
        this.fireOhlcvTickEvent(increment);
    }

    protected void fireOhlcvTickEvent(IOhlcvItem ohlcvItem) throws Exception {
        for (OhlcvChangeListener listener : this.ohlcvChangeListeners) {
            listener.tickEvent(ohlcvItem);
        }
    }

    public String getResource() {
        return this.resource;
    }

    public DataInput getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(DataInput inputSource) {
        this.inputSource = inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseResume() {
        if (this.paused.get()) {
            this.paused.set(false);
            Object object = this.pauseSemaphore;
            synchronized (object) {
                this.pauseSemaphore.notifyAll();
            }
        } else {
            this.paused.set(true);
        }
    }

    public void setUpdatePeriod(double updatePeriod) {
        this.replayMultiply.set(updatePeriod);
        if (!this.running.get()) {
            this.start();
        }
    }

    public void start() {
        this.paused.set(false);
        this.running.set(true);
        new Thread(this.getDataUpdateTask()).start();
    }

    public void step() {
        this.getDataUpdateTask().run();
    }

    public void stop() {
        if (this.running.get()) {
            this.running.set(false);
            if (this.paused.get()) {
                this.pauseResume();
            }
            try {
                if (this.scid != null) {
                    this.scid.closeActualChannel();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected Runnable getDataUpdateTask() {
        return () -> {
            while (this.running.get()) {
                try {
                    this.tick();
                    this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this, "tick"));
                    while (this.paused.get()) {
                        Object object = this.pauseSemaphore;
                        synchronized (object) {
                            this.pauseSemaphore.wait(TimeUnit.MILLISECONDS.toMillis(25L));
                        }
                    }
                }
                catch (TickDataFinishedException e) {
                    this.stop();
                }
                catch (ClosedChannelException e) {
                    LOGGER.info("The OHLCV data channel is already closed.");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    public static enum DataInput {
        OHLC_TICK;

    }
}

