/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service;

import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.TickDataFinishedException;
import de.gsi.financial.samples.service.TickOhlcvDataProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javafx.beans.property.DoubleProperty;
import org.jetbrains.annotations.NotNull;

public class SCIDByNio
implements AutoCloseable {
    private FileInputStream fileInputStream;
    private FileChannel fileChannel;
    private ByteBuffer bufferRecordDouble;
    private ByteBuffer bufferRecordFloat;
    private ByteBuffer bufferRecordULong;
    private final Calendar cal = Calendar.getInstance();
    private int timeZone;

    public void openNewChannel(String resource) throws IOException {
        this.timeZone = this.cal.get(15);
        this.fileInputStream = new FileInputStream(resource);
        this.fileChannel = this.fileInputStream.getChannel();
        this.bufferRecordDouble = ByteBuffer.allocate(8);
        this.bufferRecordDouble.order(ByteOrder.LITTLE_ENDIAN);
        this.bufferRecordFloat = ByteBuffer.allocate(4);
        this.bufferRecordFloat.order(ByteOrder.LITTLE_ENDIAN);
        this.bufferRecordULong = ByteBuffer.allocate(4);
        this.bufferRecordULong.order(ByteOrder.LITTLE_ENDIAN);
        this.fileChannel.position(56L);
    }

    public void closeActualChannel() throws IOException {
        if (this.fileChannel.isOpen()) {
            this.fileChannel.close();
        }
        this.fileInputStream.close();
    }

    @Override
    public void close() throws Exception {
        this.closeActualChannel();
    }

    public long findPositionByTimestamp(Date timestamp) throws IOException {
        long lo = 56L;
        long hi = this.fileChannel.size() - 40L;
        while (lo <= hi) {
            long mid = lo + (hi - lo) / 2L;
            Date midTimestamp = this.loadTimestamp(mid = (mid - 56L) / 40L * 40L + 56L);
            if (timestamp.before(midTimestamp)) {
                hi = mid - 40L;
                continue;
            }
            if (timestamp.after(midTimestamp)) {
                lo = mid + 40L;
                continue;
            }
            return mid;
        }
        return -lo;
    }

    public long ensureNearestTimestampPosition(Date timestamp) throws IOException {
        long position = this.findPositionByTimestamp(timestamp);
        if (position > 0L) {
            return position;
        }
        position = Math.abs(position);
        long positionEnd = this.fileChannel.size() - 40L;
        return Math.min(position, positionEnd);
    }

    public TickOhlcvDataProvider createTickDataReplayStream(@NotNull Interval<Calendar> requiredTimestamps, @NotNull Date replayStarTime, final DoubleProperty replaySpeed) throws IOException {
        long positionStart = this.ensureNearestTimestampPosition(((Calendar)requiredTimestamps.from).getTime());
        final long positionEnd = this.ensureNearestTimestampPosition(((Calendar)requiredTimestamps.to).getTime());
        final long ohlcvReplayStartIndex = this.ensureNearestTimestampPosition(replayStarTime);
        this.fileChannel.position(positionStart);
        return new TickOhlcvDataProvider(){
            private OHLCVItem prevItem = null;
            private OHLCVItem item = null;

            @Override
            public OHLCVItem get() throws TickDataFinishedException, IOException {
                long position = SCIDByNio.this.fileChannel.position();
                if (positionEnd != -1L && position >= positionEnd) {
                    throw new TickDataFinishedException("The replay finished.");
                }
                if (position >= ohlcvReplayStartIndex) {
                    long prevTime = this.prevItem != null ? this.prevItem.getTimeStamp().getTime() : 0L;
                    long time = this.item != null ? this.item.getTimeStamp().getTime() : 0L;
                    long waitingTime = Math.round((double)(time - prevTime) / replaySpeed.get());
                    waitingTime = Math.max(1L, waitingTime);
                    try {
                        Thread.sleep(waitingTime);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.prevItem = this.item;
                this.item = SCIDByNio.this.loadOhlcvItemRealtime();
                return this.item;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OHLCVItem loadOhlcvItemRealtime() throws IOException {
        float close;
        int bytesRead;
        do {
            if ((bytesRead = this.fileChannel.read(this.bufferRecordDouble)) != -1) continue;
            SCIDByNio sCIDByNio = this;
            synchronized (sCIDByNio) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(25L));
            }
        } while (bytesRead == -1);
        this.bufferRecordDouble.flip();
        double dt = this.bufferRecordDouble.getDouble();
        this.bufferRecordDouble.clear();
        if (this.fileChannel.read(this.bufferRecordFloat) < 0) {
            throw new IOException("could not read open values");
        }
        this.bufferRecordFloat.clear();
        if (this.fileChannel.read(this.bufferRecordFloat) < 0) {
            throw new IOException("could not read high values");
        }
        this.bufferRecordFloat.flip();
        float high = this.bufferRecordFloat.getFloat();
        this.bufferRecordFloat.clear();
        if (this.fileChannel.read(this.bufferRecordFloat) < 0) {
            throw new IOException("could not read low values");
        }
        this.bufferRecordFloat.flip();
        float low = this.bufferRecordFloat.getFloat();
        this.bufferRecordFloat.clear();
        if (this.fileChannel.read(this.bufferRecordFloat) < 0) {
            throw new IOException("could not read close values");
        }
        this.bufferRecordFloat.flip();
        float open = close = this.bufferRecordFloat.getFloat();
        this.bufferRecordFloat.clear();
        if (this.fileChannel.read(this.bufferRecordULong) < 0) {
            throw new IOException("could not read number of trade values");
        }
        this.bufferRecordULong.flip();
        this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        if (this.fileChannel.read(this.bufferRecordULong) < 0) {
            throw new IOException("could not read total volume values");
        }
        this.bufferRecordULong.flip();
        long totalVolume = this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        if (this.fileChannel.read(this.bufferRecordULong) < 0) {
            throw new IOException("could not read bid volume values");
        }
        this.bufferRecordULong.flip();
        long bidVolume = this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        if (this.fileChannel.read(this.bufferRecordULong) < 0) {
            throw new IOException("could not read ask volume values");
        }
        this.bufferRecordULong.flip();
        long askVolume = this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        Date timestamp = new Date(this.convertWindowsTimeToMilliseconds(dt));
        return new OHLCVItem(timestamp, open, high, low, close, totalVolume, 0.0, askVolume, bidVolume);
    }

    private Date loadTimestamp(long position) throws IOException {
        this.fileChannel.position(position);
        int bytesRead = this.fileChannel.read(this.bufferRecordDouble);
        if (bytesRead == -1) {
            throw new IOException("could not read time-stamp for position: " + position);
        }
        this.bufferRecordDouble.flip();
        double dt = this.bufferRecordDouble.getDouble();
        this.bufferRecordDouble.clear();
        return new Date(this.convertWindowsTimeToMilliseconds(dt));
    }

    public long convertWindowsTimeToMilliseconds(double comTime) {
        long result = Math.round(8.64E7 * (comTime -= 25569.0)) - (long)this.timeZone;
        this.cal.setTime(new Date(result));
        return result -= (long)this.cal.get(16);
    }
}

