/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConcurrentDateFormatAccess {
    private final String simpleDateFormatString;
    private final ThreadLocal<DateFormat> df = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(ConcurrentDateFormatAccess.this.simpleDateFormatString);
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };

    public ConcurrentDateFormatAccess(String dateFormatMask) {
        this.simpleDateFormatString = dateFormatMask;
    }

    public ConcurrentDateFormatAccess() {
        this.simpleDateFormatString = "MM/dd/yyyy";
    }

    public Date parse(String dateString) throws ParseException {
        return this.df.get().parse(dateString);
    }

    public String format(Date date) {
        return this.df.get().format(date);
    }
}

