/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service;

import de.gsi.financial.samples.dos.Interval;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class CalendarUtils {
    public static Interval<Calendar> createByDateInterval(String dateIntervalPattern) throws ParseException {
        if (dateIntervalPattern == null) {
            throw new ParseException("The resource date interval pattern is null", -1);
        }
        String[] parts = dateIntervalPattern.split("-");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        ArrayList<Calendar> calendarList = new ArrayList<Calendar>();
        for (String time : parts) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(sdf.parse(time));
            calendarList.add(DateUtils.truncate((Calendar)cal, (int)5));
        }
        return new Interval<Calendar>((Calendar)calendarList.get(0), (Calendar)calendarList.get(1));
    }

    public static Interval<Calendar> createByDateTimeInterval(String datetimeIntervalPattern) throws ParseException {
        if (datetimeIntervalPattern == null) {
            throw new ParseException("The resource datetime interval pattern is null", -1);
        }
        String[] parts = datetimeIntervalPattern.split("-");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        ArrayList<Calendar> calendarList = new ArrayList<Calendar>();
        for (String time : parts) {
            Date fromTotime = sdf.parse(time);
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromTotime);
            cal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), 0);
            calendarList.add(cal);
        }
        return new Interval<Calendar>((Calendar)calendarList.get(0), (Calendar)calendarList.get(1));
    }

    public static Interval<Calendar> createByTimeInterval(String timeIntervalPattern) throws ParseException {
        if (timeIntervalPattern == null) {
            throw new ParseException("The resource time interval pattern is null", -1);
        }
        String[] parts = timeIntervalPattern.split("-");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        ArrayList<Calendar> calendarList = new ArrayList<Calendar>();
        for (String time : parts) {
            Date fromTotime = sdf.parse(time);
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromTotime);
            cal.set(1900, 0, 1, cal.get(11), cal.get(12), 0);
            calendarList.add(cal);
        }
        return new Interval<Calendar>((Calendar)calendarList.get(0), (Calendar)calendarList.get(1));
    }

    public static Calendar createByDateTime(String datetimePattern) throws ParseException {
        if (datetimePattern == null) {
            throw new ParseException("The resource datetime pattern is null", -1);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        Date fromTotime = sdf.parse(datetimePattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(fromTotime);
        cal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), 0);
        return cal;
    }
}

