/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import java.util.Date;

public class OrderExpression {
    public static final TIF TIF_NEXT_BAR = new TIF(TimeInForce.NEXT_BAR);
    private final OrderBuySell buySell;
    private final OrderType orderType;
    private final int orderQuantity;
    private Double price;
    private Double price2;
    private MarketOnPrice marketOnPrice = MarketOnPrice.CLOSE_PRICE;
    private TIF tif = new TIF();

    public OrderExpression(OrderBuySell buySell, OrderType orderType, int orderQuantity) {
        this.buySell = buySell;
        this.orderType = orderType;
        this.orderQuantity = orderQuantity;
    }

    public OrderExpression(OrderBuySell buySell, OrderType orderType, int orderQuantity, Double price) {
        this.buySell = buySell;
        this.orderType = orderType;
        this.orderQuantity = orderQuantity;
        this.price = price;
    }

    public OrderExpression(OrderBuySell buySell, OrderType orderType, int orderQuantity, Double price, TIF tif) {
        this.buySell = buySell;
        this.orderType = orderType;
        this.orderQuantity = orderQuantity;
        this.price = price;
        this.tif = tif;
    }

    public OrderExpression(OrderBuySell buySell, OrderType orderType, int orderQuantity, Double price, TIF tif, MarketOnPrice marketOnPrice) {
        this.buySell = buySell;
        this.orderType = orderType;
        this.orderQuantity = orderQuantity;
        this.price = price;
        if (tif != null) {
            this.tif = tif;
        }
        this.marketOnPrice = marketOnPrice;
    }

    public OrderExpression(OrderBuySell buySell, OrderType orderType, int orderQuantity, Double price, Double price2) {
        this.buySell = buySell;
        this.orderType = orderType;
        this.orderQuantity = orderQuantity;
        this.price = price;
        this.price2 = price2;
    }

    public OrderExpression(OrderBuySell buySell, OrderType orderType, int orderQuantity, Double price, Double price2, TIF tif) {
        this.buySell = buySell;
        this.orderType = orderType;
        this.orderQuantity = orderQuantity;
        this.price = price;
        this.price2 = price2;
        this.tif = tif;
    }

    public static OrderExpression buyMarket(int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity);
    }

    public static OrderExpression buyMarketOnTestPrice(int quantity, double price) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity, (Double)price, new TIF(), MarketOnPrice.TEST_PRICE);
    }

    public static OrderExpression buyMarket(int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity, null, tif, MarketOnPrice.CLOSE_PRICE);
    }

    public static OrderExpression sellMarket(int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MARKET, quantity);
    }

    public static OrderExpression sellMarketOnTestPrice(int quantity, double price) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MARKET, quantity, (Double)price, new TIF(), MarketOnPrice.TEST_PRICE);
    }

    public static OrderExpression sellMarket(int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MARKET, quantity, null, tif, MarketOnPrice.CLOSE_PRICE);
    }

    public static OrderExpression buyMarketOnOpenPrice(int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity, null, null, MarketOnPrice.OPEN_PRICE);
    }

    public static OrderExpression buyMarketOnOpenPrice(int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity, null, tif, MarketOnPrice.OPEN_PRICE);
    }

    public static OrderExpression sellMarketOnOpenPrice(int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MARKET, quantity, null, null, MarketOnPrice.OPEN_PRICE);
    }

    public static OrderExpression sellMarketOnOpenPrice(int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MARKET, quantity, null, tif, MarketOnPrice.OPEN_PRICE);
    }

    public static OrderExpression buyMarketNextBar(int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity, null, TIF_NEXT_BAR);
    }

    public static OrderExpression buyMarketNextBarOnOpenPrice(int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MARKET, quantity, null, TIF_NEXT_BAR, MarketOnPrice.OPEN_PRICE);
    }

    public static OrderExpression sellMarketNextBar(int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MARKET, quantity, null, TIF_NEXT_BAR);
    }

    public static OrderExpression buyMarketOnClose(int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MOC, quantity);
    }

    public static OrderExpression sellMarketOnClose(int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MOC, quantity);
    }

    public static OrderExpression buyMarketOnOpen(int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MOO, quantity);
    }

    public static OrderExpression sellMarketOnOpen(int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MOO, quantity);
    }

    public static OrderExpression buyMarketInTouch(double price, int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MIT, quantity, price);
    }

    public static OrderExpression sellMarketInTouch(double price, int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MIT, quantity, price);
    }

    public static OrderExpression buyMarketInTouch(double price, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.MIT, quantity, (Double)price, tif);
    }

    public static OrderExpression sellMarketInTouch(double price, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.MIT, quantity, (Double)price, tif);
    }

    public static OrderExpression buyLimit(double price, int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.LIMIT, quantity, price);
    }

    public static OrderExpression sellLimit(double price, int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.LIMIT, quantity, price);
    }

    public static OrderExpression buyLimit(double price, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.LIMIT, quantity, (Double)price, tif);
    }

    public static OrderExpression sellLimit(double price, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.LIMIT, quantity, (Double)price, tif);
    }

    public static OrderExpression buyStop(double price, int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.STOP, quantity, price);
    }

    public static OrderExpression sellStop(double price, int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.STOP, quantity, price);
    }

    public static OrderExpression buyStop(double price, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.STOP, quantity, (Double)price, tif);
    }

    public static OrderExpression sellStop(double price, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.STOP, quantity, (Double)price, tif);
    }

    public static OrderExpression buyStopLimit(double price, double price2, int quantity) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.STOP_LIMIT, quantity, (Double)price, price2);
    }

    public static OrderExpression sellStopLimit(double price, double price2, int quantity) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.STOP_LIMIT, quantity, (Double)price, price2);
    }

    public static OrderExpression buyStopLimit(double price, double price2, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.BUY, OrderType.STOP_LIMIT, quantity, (Double)price, price2, tif);
    }

    public static OrderExpression sellStopLimit(double price, double price2, int quantity, TIF tif) {
        return new OrderExpression(OrderBuySell.SELL, OrderType.STOP_LIMIT, quantity, (Double)price, price2, tif);
    }

    public OrderBuySell getBuySell() {
        return this.buySell;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public int getOrderQuantity() {
        return this.orderQuantity;
    }

    public Double getPrice() {
        return this.price;
    }

    public Double getPrice2() {
        return this.price2;
    }

    public MarketOnPrice getMarketOnPrice() {
        return this.marketOnPrice;
    }

    public TIF getTif() {
        return this.tif;
    }

    public String toString() {
        return this.buySell + " " + this.orderType + (String)(this.price != null ? " " + this.price : "") + (String)(this.price2 != null ? " " + this.price2 : "") + " Q" + this.orderQuantity + ", " + this.tif;
    }

    public static class TIF {
        private TimeInForce tif = TimeInForce.DAY;
        private Date goodTillDateTimeFrom;
        private Date goodTillDateTimeTo;

        public TIF() {
        }

        public TIF(TimeInForce tif) {
            this.tif = tif;
        }

        public TIF(Date goodTillDateTimeFrom, Date goodTillDateTimeTo) {
            this.tif = TimeInForce.GTDT;
            this.goodTillDateTimeFrom = goodTillDateTimeFrom;
            this.goodTillDateTimeTo = goodTillDateTimeTo;
        }

        public TIF(Date goodTillDateTimeFrom) {
            this.tif = TimeInForce.GTDT;
            this.goodTillDateTimeFrom = goodTillDateTimeFrom;
            this.goodTillDateTimeTo = null;
        }

        public TimeInForce getTif() {
            return this.tif;
        }

        public Date getGoodTillDateTimeFrom() {
            return this.goodTillDateTimeFrom;
        }

        public Date getGoodTillDateTimeTo() {
            return this.goodTillDateTimeTo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.goodTillDateTimeFrom == null ? 0 : this.goodTillDateTimeFrom.hashCode());
            result = 31 * result + (this.goodTillDateTimeTo == null ? 0 : this.goodTillDateTimeTo.hashCode());
            result = 31 * result + (this.tif == null ? 0 : this.tif.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TIF other = (TIF)obj;
            if (this.goodTillDateTimeFrom == null ? other.goodTillDateTimeFrom != null : !this.goodTillDateTimeFrom.equals(other.goodTillDateTimeFrom)) {
                return false;
            }
            if (this.goodTillDateTimeTo == null ? other.goodTillDateTimeTo != null : !this.goodTillDateTimeTo.equals(other.goodTillDateTimeTo)) {
                return false;
            }
            return this.tif == other.tif;
        }

        public String toString() {
            if (TimeInForce.GTDT.equals((Object)this.tif)) {
                return "TIF [TIF=" + this.tif + ", GTD-From=" + this.goodTillDateTimeFrom + ", GTD-To=" + this.goodTillDateTimeTo + "]";
            }
            return this.tif.toString();
        }
    }

    public static enum MarketOnPrice {
        OPEN_PRICE,
        CLOSE_PRICE,
        TEST_PRICE;

    }

    public static enum TimeInForce {
        DAY,
        GTC,
        GTDT,
        NEXT_BAR;

    }

    public static enum OrderType {
        MARKET,
        LIMIT,
        STOP,
        MIT,
        STOP_LIMIT,
        MOC,
        MOO,
        OCO_LIMIT_STOP,
        OCO_BUY_STOP_SELL_STOP;

    }

    public static enum OrderBuySell {
        BUY,
        SELL;

    }
}

