/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.financial.samples.dos.Order;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OrderContainer {
    private final Map<Integer, Order> orders = new LinkedHashMap<Integer, Order>();
    private final HashSet<Order> openedOrders = new LinkedHashSet<Order>();

    public void addOrder(Order order) {
        this.openedOrders.add(order);
        this.orders.put(order.getInternalOrderId(), order);
    }

    public Order removeOrder(Order order) {
        this.openedOrders.remove(order);
        return this.orders.remove(order.getInternalOrderId());
    }

    public boolean removeOpenedOrder(Order order) {
        return this.openedOrders.remove(order);
    }

    public Collection<Order> getOrders() {
        return this.orders.values();
    }

    public Collection<Order> getOpenedOrders() {
        return (LinkedHashSet)this.openedOrders.clone();
    }

    public Set<Order> getOpenedAndFilledOrders() {
        LinkedHashSet<Order> openOrders = new LinkedHashSet<Order>();
        for (Order order : this.getOrders()) {
            if (Order.OrderStatus.OPENED != order.getStatus() && Order.OrderStatus.FILLED != order.getStatus()) continue;
            openOrders.add(order);
        }
        return openOrders;
    }

    public Set<Order> getOpenedAndFilledOrdersByMarket(String symbol) {
        LinkedHashSet<Order> marketOrders = new LinkedHashSet<Order>();
        if (symbol != null) {
            for (Order order : this.getOpenedAndFilledOrders()) {
                if (!order.getSymbol().equals(symbol)) continue;
                marketOrders.add(order);
            }
        }
        return marketOrders;
    }

    public Order getOrderById(int internalOrderId) {
        return this.orders.get(internalOrderId);
    }

    public void clear() {
        this.orders.clear();
    }

    public boolean contains(Order order) {
        return this.orders.containsKey(order.getInternalOrderId());
    }

    public String toString() {
        return "OrderContainer [orders=" + this.orders + "]";
    }
}

