/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcv;
import de.gsi.financial.samples.dos.ArrayIterator;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.period.EodPeriod;
import de.gsi.financial.samples.service.period.Period;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;

public class DefaultOHLCV
implements IOhlcv {
    private OHLCVItem[] ohlcvItems = new OHLCVItem[0];
    private String id;
    private String name;
    private String title;
    private String description;
    private String assetName;
    private String symbol;
    private String studyCategory;
    private Period period = new EodPeriod();
    private OHLCVStateAttributes stateAttributes = new OHLCVStateAttributes();
    private AttributeModel addon;
    private OhlcvTimestampComparator ohlcvTimestampComparator = null;

    public void setAddon(AttributeModel addon) {
        this.addon = addon;
    }

    public AttributeModel getAddon() {
        return this.addon;
    }

    public AttributeModel getAddonOrCreate() {
        if (this.addon == null) {
            this.addon = new AttributeModel();
        }
        return this.addon;
    }

    public boolean isConsolidated() {
        return this.stateAttributes.consolidated;
    }

    public void setConsolidated(boolean consolidated) {
        this.stateAttributes.consolidated = consolidated;
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStudyCategory() {
        return this.studyCategory;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Period getPeriod() {
        return this.period;
    }

    public OHLCVItem getOhlcvItem(int sampleId) {
        return this.ohlcvItems[sampleId + this.stateAttributes.lowerBound];
    }

    public OHLCVItem getBackOhlcvItem(int sampleId) {
        return this.getOhlcvItem(this.size() - 1 - sampleId);
    }

    public OHLCVItem[] getOhlcvItemsArray() {
        if (this.stateAttributes.lowerBound == 0 && this.stateAttributes.userUpperBound == -1 && this.stateAttributes.upperBound == -1) {
            return this.ohlcvItems;
        }
        OHLCVItem[] newItemArray = new OHLCVItem[this.stateAttributes.size];
        System.arraycopy(this.ohlcvItems, this.stateAttributes.lowerBound, newItemArray, 0, this.stateAttributes.size);
        return newItemArray;
    }

    public List<OHLCVItem> getOhlcvItemsList() {
        return Arrays.asList(this.getOhlcvItemsArray());
    }

    public Iterator iterator() {
        if (this.stateAttributes.upperBound == -1) {
            return new ArrayIterator(this.ohlcvItems, this.stateAttributes.lowerBound);
        }
        return new ArrayIterator(this.ohlcvItems, this.stateAttributes.lowerBound, this.stateAttributes.upperBound);
    }

    public int size() {
        return this.stateAttributes.size;
    }

    public Date getTimestamp(int sampleId) {
        return this.ohlcvItems[sampleId + this.stateAttributes.lowerBound].getTimeStamp();
    }

    public double getValue(int sampleId) {
        return this.ohlcvItems[sampleId + this.stateAttributes.lowerBound].getClose();
    }

    public double getBackValue(int sampleId) {
        return this.getValue(this.size() - 1 - sampleId);
    }

    public OHLCVItem getLastValue() {
        return this.ohlcvItems[this.stateAttributes.lastValueIndex];
    }

    public OHLCVItem getOhlcvItemByTimestamp(Date timestamp, int field) {
        int index = this.getIndexByTimestamp(timestamp, field);
        if (index < 0) {
            return null;
        }
        return this.ohlcvItems[index + this.stateAttributes.lowerBound];
    }

    public synchronized int getIndexByTimestamp(Date timestamp, int field) {
        int i;
        OHLCVItem item = new OHLCVItem(timestamp, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (this.ohlcvTimestampComparator == null || this.ohlcvTimestampComparator.field != field) {
            this.ohlcvTimestampComparator = new OhlcvTimestampComparator(field);
        }
        if ((i = Arrays.binarySearch(this.ohlcvItems, item, this.ohlcvTimestampComparator)) < 0) {
            if (Math.abs(i) - 1 == this.ohlcvItems.length) {
                return -1 * (this.stateAttributes.size + 1);
            }
            return -(-i - this.stateAttributes.lowerBound);
        }
        if ((i -= this.stateAttributes.lowerBound) >= this.stateAttributes.size) {
            return -1 * (this.stateAttributes.size + 1);
        }
        return i;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStudyCategory(String studyCategory) {
        this.studyCategory = studyCategory;
    }

    public void setOhlcvItems(OHLCVItem[] ohlcvItems) {
        this.ohlcvItems = ohlcvItems;
        this.datasetChanged();
    }

    public void addOhlcvItems(List<OHLCVItem> ohlcvItems) {
        this.addOhlcvItems(ohlcvItems.toArray(new OHLCVItem[ohlcvItems.size()]));
    }

    public void addOhlcvItems(OHLCVItem[] _ohlcvItems) {
        OHLCVItem[] newOhlcvItems = new OHLCVItem[this.ohlcvItems.length + _ohlcvItems.length];
        System.arraycopy(this.ohlcvItems, 0, newOhlcvItems, 0, this.ohlcvItems.length);
        for (int i = 0; i < _ohlcvItems.length; ++i) {
            newOhlcvItems[this.ohlcvItems.length + i] = _ohlcvItems[i];
        }
        this.ohlcvItems = newOhlcvItems;
        this.minMaxValueChanged(this.ohlcvItems);
        this.datasetChanged();
    }

    public void addOhlcvItem(OHLCVItem ohlcvItem) {
        OHLCVItem[] newOhlcvItems = new OHLCVItem[this.ohlcvItems.length + 1];
        System.arraycopy(this.ohlcvItems, 0, newOhlcvItems, 0, this.ohlcvItems.length);
        newOhlcvItems[this.ohlcvItems.length] = ohlcvItem;
        this.ohlcvItems = newOhlcvItems;
        this.minMaxValueChanged(ohlcvItem);
        this.datasetChanged();
    }

    private void minMaxValueChanged(OHLCVItem[] ohlcvItems) {
        for (OHLCVItem ohlcvItem : ohlcvItems) {
            this.minMaxValueChanged(ohlcvItem);
        }
    }

    private void minMaxValueChanged(OHLCVItem ohlcvItem) {
        double high = ohlcvItem.getHigh();
        double low = ohlcvItem.getLow();
        if (high > this.stateAttributes.maxValue || Double.isNaN(this.stateAttributes.maxValue)) {
            this.stateAttributes.maxValue = high;
        }
        if (low < this.stateAttributes.minValue || Double.isNaN(this.stateAttributes.minValue)) {
            this.stateAttributes.minValue = low;
        }
    }

    public void updateOhlcvItem(int index, OHLCVItem ohlcvItem) {
        this.ohlcvItems[index] = ohlcvItem;
        this.minMaxValueChanged(ohlcvItem);
    }

    public void setMinValue(double minValue) {
        this.stateAttributes.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.stateAttributes.maxValue = maxValue;
    }

    public double getMinValue() {
        return this.stateAttributes.minValue;
    }

    public double getMaxValue() {
        return this.stateAttributes.maxValue;
    }

    public static IOhlcv createShellCopyRangedOHLCV(DefaultOHLCV rOHLCV) {
        DefaultOHLCV rangedOHLCV = new DefaultOHLCV();
        rangedOHLCV.setAssetName(rOHLCV.assetName);
        rangedOHLCV.setDescription(rOHLCV.title);
        rangedOHLCV.setId(rOHLCV.title);
        rangedOHLCV.setName(rOHLCV.title);
        rangedOHLCV.setSymbol(rOHLCV.symbol);
        rangedOHLCV.setTitle(rOHLCV.title);
        rangedOHLCV.setOhlcvItems(rOHLCV.ohlcvItems);
        rangedOHLCV.stateAttributes = rOHLCV.stateAttributes;
        return rangedOHLCV;
    }

    public static IOhlcv createOHLCV(String assetName, String symbol, String title, OHLCVItem[] ohlcvItems, double minValue, double maxValue) {
        DefaultOHLCV rangedOHLCV = new DefaultOHLCV();
        rangedOHLCV.setAssetName(assetName);
        rangedOHLCV.setDescription(title);
        rangedOHLCV.setId(title);
        rangedOHLCV.setName(title);
        rangedOHLCV.setSymbol(symbol);
        rangedOHLCV.setTitle(title);
        rangedOHLCV.setOhlcvItems(ohlcvItems);
        rangedOHLCV.setMinValue(minValue);
        rangedOHLCV.setMaxValue(maxValue);
        return rangedOHLCV;
    }

    public IOhlcv createRestrictedOHLCV(int[] range) {
        DefaultOHLCV rangedOHLCV = new DefaultOHLCV();
        rangedOHLCV.stateAttributes.lowerBound = range[0];
        rangedOHLCV.stateAttributes.upperBound = range[1];
        rangedOHLCV.setAssetName(this.assetName);
        rangedOHLCV.setDescription(this.description);
        rangedOHLCV.setId(this.id);
        rangedOHLCV.setName(this.name);
        rangedOHLCV.setSymbol(this.symbol);
        rangedOHLCV.setTitle(this.title);
        rangedOHLCV.setConsolidated(this.stateAttributes.consolidated);
        rangedOHLCV.setOhlcvItems(this.ohlcvItems);
        return rangedOHLCV;
    }

    public void setUserUpperBound(int upper) {
        this.stateAttributes.userUpperBound = upper + this.stateAttributes.lowerBound;
        this.datasetChanged();
    }

    public int getUserUpperBound() {
        return this.stateAttributes.userUpperBound - this.stateAttributes.lowerBound;
    }

    public void clearUserUpperBound() {
        this.stateAttributes.userUpperBound = -1;
        this.datasetChanged();
    }

    public int getLowerBound() {
        return this.stateAttributes.lowerBound;
    }

    public int getUpperBound() {
        return this.stateAttributes.upperBound;
    }

    public void increaseUserUpperBound(int i) {
        this.stateAttributes.userUpperBound += i;
        this.datasetChanged();
    }

    protected void datasetChanged() {
        this.stateAttributes.size = this.stateAttributes.userUpperBound == -1 ? (this.stateAttributes.upperBound == -1 ? this.ohlcvItems.length - this.stateAttributes.lowerBound : this.stateAttributes.upperBound + 1 - this.stateAttributes.lowerBound) : this.stateAttributes.userUpperBound + 1 - this.stateAttributes.lowerBound;
        this.stateAttributes.lastValueIndex = this.stateAttributes.size - 1 + this.stateAttributes.lowerBound;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assetName == null ? 0 : this.assetName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.period == null ? 0 : this.period.hashCode());
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultOHLCV other = (DefaultOHLCV)obj;
        if (this.assetName == null ? other.assetName != null : !this.assetName.equals(other.assetName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.period == null ? other.period != null : !this.period.equals(other.period)) {
            return false;
        }
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    public String toString() {
        return "OHLCV [id=" + this.id + ", name=" + this.name + ", title=" + this.title + ", assetName=" + this.assetName + ", symbol=" + this.symbol + ", period=" + this.period + "]";
    }

    private class OhlcvTimestampComparator
    implements Comparator<OHLCVItem> {
        public int field;

        public OhlcvTimestampComparator(int field) {
            this.field = field;
        }

        @Override
        public int compare(OHLCVItem o1, OHLCVItem o2) {
            return DateUtils.truncatedCompareTo((Date)o1.getTimeStamp(), (Date)o2.getTimeStamp(), (int)this.field);
        }
    }

    public static class OHLCVStateAttributes {
        public boolean consolidated = false;
        public int lowerBound = 0;
        public int upperBound = -1;
        public int userUpperBound = -1;
        public int size;
        public int lastValueIndex;
        public double minValue = Double.NaN;
        public double maxValue = Double.NaN;

        public String toString() {
            return "OHLCVStateAttributes [consolidated=" + this.consolidated + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", userUpperBound=" + this.userUpperBound + ", size=" + this.size + ", lastValueIndex=" + this.lastValueIndex + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + "]";
        }
    }
}

