/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.renderer.spi.financial.FootprintRenderer;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.footprint.FootprintRendererAttributes;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.financial.samples.FinancialRealtimeCandlestickSample;
import de.gsi.financial.samples.service.addon.AbsorptionConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.footprint.AbsorptionClusterRendererPaintAfterEP;
import de.gsi.financial.samples.service.footprint.DiagonalDominantNbColumnColorGroupService;
import de.gsi.financial.samples.service.footprint.FootprintRenderedAPIAdapter;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.util.HashMap;
import javafx.application.Application;

public class FinancialRealtimeFootprintSample
extends FinancialRealtimeCandlestickSample {
    @Override
    protected void configureApp() {
        this.title = "Replay FOOTPRINT Tick Data in real-time (press 'replay' button, zoom by mousewheel)";
        this.theme = "DARK";
        this.resource = "REALTIME_OHLC_TICK";
        this.timeRange = "2016/07/29 13:25-2016/07/29 14:25";
        this.tt = "00:00-23:59";
        this.replayFrom = "2016/07/29 13:58";
        this.consolidationAddons = new HashMap();
        this.consolidationAddons.put("footprintCalcAddons", new OhlcvConsolidationAddon[]{new AbsorptionConsolidationAddon(false, 70, 3, 0.33, 100.0)});
        this.period = new IntradayPeriod(IntradayPeriod.IntradayPeriodEnum.M, 2.0, 0.0, true, "footprintCalcAddons");
    }

    @Override
    protected void prepareRenderers(XYChart chart, OhlcvDataSet ohlcvDataSet, DefaultDataSet indiSet) {
        FootprintRendererAttributes footprintAttrs = FootprintRendererAttributes.getDefaultValues((String)this.theme);
        FootprintRenderer renderer = new FootprintRenderer((FootprintRenderer.IFootprintRenderedAPI)new FootprintRenderedAPIAdapter(footprintAttrs, new DiagonalDominantNbColumnColorGroupService(footprintAttrs)), true, true, true);
        renderer.addPaintAfterEp((RendererPaintAfterEP)new AbsorptionClusterRendererPaintAfterEP((DataSet)ohlcvDataSet, chart));
        renderer.getDatasets().addAll((Object[])new DataSet[]{ohlcvDataSet});
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)renderer);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

