/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.YRangeIndicator;
import de.gsi.chart.plugins.YWatchValueIndicator;
import de.gsi.chart.renderer.spi.financial.AbstractFinancialRenderer;
import de.gsi.chart.renderer.spi.financial.CandleStickRenderer;
import de.gsi.chart.renderer.spi.financial.PositionFinancialRendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEPAware;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.financial.samples.AbstractBasicFinancialApplication;
import de.gsi.financial.samples.dos.OrderContainer;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.SimpleOhlcvReplayDataSet;
import de.gsi.financial.samples.service.StandardTradePlanAttributes;
import de.gsi.financial.samples.service.execution.BacktestExecutionPlatform;
import de.gsi.financial.samples.service.execution.BasicOrderExecutionService;
import de.gsi.financial.samples.service.order.PositionFinancialDataSet;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import de.gsi.financial.samples.service.plan.MktOrderListTradePlan;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class FinancialRealtimeCandlestickSample
extends AbstractBasicFinancialApplication {
    @Override
    protected void configureApp() {
        this.title = "Replay OHLC/V Tick Data in real-time (press 'replay' button, zoom by mousewheel)";
        this.theme = "SAND";
        this.resource = "REALTIME_OHLC_TICK";
        this.timeRange = "2016/07/29 00:00-2016/07/29 20:15";
        this.tt = "00:00-23:59";
        this.replayFrom = "2016/07/29 13:58";
        this.period = new IntradayPeriod(IntradayPeriod.IntradayPeriodEnum.M, 2.0);
    }

    @Override
    protected Scene prepareScene() {
        String priceFormat = "%1.1f";
        ArrayList<MktOrderListTradePlan.SimMktOrder> orders = new ArrayList<MktOrderListTradePlan.SimMktOrder>();
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 14:06", 3));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 14:15", -1));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 14:24", -1));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 14:36", -1));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 15:10", -3));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 15:38", 3));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 16:39", -3));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 16:44", 1));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 16:56", 1));
        orders.add(new MktOrderListTradePlan.SimMktOrder("2016/07/29 18:40", 1));
        Chart chart = this.getDefaultFinancialTestChart(this.theme);
        AbstractFinancialRenderer renderer = (AbstractFinancialRenderer)chart.getRenderers().get(0);
        chart.setTitle(this.title);
        ToolBar testVariableToolBar = this.getTestToolBar(chart, renderer, true);
        Axis yAxis = (Axis)chart.getAxes().get(1);
        if (this.ohlcvDataSet instanceof SimpleOhlcvReplayDataSet) {
            SimpleOhlcvReplayDataSet replayDataSet = (SimpleOhlcvReplayDataSet)this.ohlcvDataSet;
            YWatchValueIndicator closeIndicator = new YWatchValueIndicator(yAxis, priceFormat);
            closeIndicator.setPreventOcclusion(true);
            closeIndicator.setId("price");
            closeIndicator.setLineVisible(false);
            closeIndicator.setEditable(false);
            chart.getPlugins().add((Object)closeIndicator);
            replayDataSet.addOhlcvChangeListener(ohlcvItem -> FXUtils.runFX(() -> closeIndicator.setMarkerValue(ohlcvItem.getClose())));
            AttributeModel context = new AttributeModel().setAttribute(StandardTradePlanAttributes.ORDERS, (Object)new OrderContainer()).setAttribute(StandardTradePlanAttributes.POSITIONS, (Object)new PositionContainer());
            String asset = replayDataSet.getResource();
            PositionFinancialDataSet positionFinancialDataSet = new PositionFinancialDataSet(asset, this.ohlcvDataSet, context);
            if (renderer instanceof RendererPaintAfterEPAware) {
                ((RendererPaintAfterEPAware)renderer).addPaintAfterEp((RendererPaintAfterEP)new PositionFinancialRendererPaintAfterEP((DataSet)positionFinancialDataSet, (XYChart)chart));
            }
            BacktestExecutionPlatform executionPlatform = new BacktestExecutionPlatform();
            executionPlatform.setContext(context);
            executionPlatform.addExecutionPlatformListener(positionFinancialDataSet);
            BasicOrderExecutionService orderExecutionService = new BasicOrderExecutionService(context, executionPlatform);
            MktOrderListTradePlan tradePlan = new MktOrderListTradePlan(context, asset, orderExecutionService, orders);
            replayDataSet.addOhlcvChangeListener(tradePlan);
            replayDataSet.addOhlcvChangeListener(executionPlatform);
        }
        chart.getPlugins().add((Object)new YWatchValueIndicator(yAxis, priceFormat, 4727.5));
        chart.getPlugins().add((Object)new YWatchValueIndicator(yAxis, priceFormat, 4715.0));
        chart.getPlugins().add((Object)this.createRsLevel(yAxis, 4710.0, 4711.0, "Daily Support"));
        chart.getPlugins().add((Object)this.createRsLevel(yAxis, 4731.0, 4733.0, "Daily Resistance"));
        this.applyColorScheme(this.theme, (XYChart)chart);
        VBox root = new VBox();
        VBox.setVgrow((Node)chart, (Priority)Priority.SOMETIMES);
        root.getChildren().addAll((Object[])new Node[]{testVariableToolBar, chart});
        return new Scene((Parent)root, (double)this.prefSceneWidth, (double)this.prefSceneHeight);
    }

    protected YRangeIndicator createRsLevel(Axis yAxis, double lowerBound, double upperBound, String description) {
        YRangeIndicator rangeIndi = new YRangeIndicator(yAxis, lowerBound, upperBound, description);
        rangeIndi.setLabelHorizontalAnchor(HPos.LEFT);
        rangeIndi.setLabelHorizontalPosition(0.01);
        return rangeIndi;
    }

    @Override
    protected void prepareRenderers(XYChart chart, OhlcvDataSet ohlcvDataSet, DefaultDataSet indiSet) {
        CandleStickRenderer renderer = new CandleStickRenderer(true);
        renderer.getDatasets().addAll((Object[])new DataSet[]{ohlcvDataSet});
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)renderer);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

