/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.financial.AbstractFinancialRenderer;
import de.gsi.chart.renderer.spi.financial.css.FinancialColorSchemeAware;
import de.gsi.chart.renderer.spi.financial.css.FinancialColorSchemeConfig;
import de.gsi.chart.renderer.spi.financial.css.FinancialColorSchemeConstants;
import de.gsi.chart.ui.ProfilerInfoBox;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcv;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.service.CalendarUtils;
import de.gsi.financial.samples.service.SimpleOhlcvDailyParser;
import de.gsi.financial.samples.service.SimpleOhlcvReplayDataSet;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.io.IOException;
import java.text.ParseException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasicFinancialApplication
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBasicFinancialApplication.class);
    protected int prefChartWidth = 640;
    protected int prefChartHeight = 480;
    protected int prefSceneWidth = 1920;
    protected int prefSceneHeight = 1080;
    private final double UPDATE_PERIOD = 10.0;
    protected int DEBUG_UPDATE_RATE = 500;
    protected String title;
    protected String theme = "SAND";
    protected String resource = "@ES-[TF1D]";
    protected String timeRange = "2020/08/24 0:00-2020/11/12 0:00";
    protected String tt;
    protected String replayFrom;
    protected IntradayPeriod period;
    protected OhlcvDataSet ohlcvDataSet;
    protected Map<String, OhlcvConsolidationAddon[]> consolidationAddons;
    protected final FinancialColorSchemeAware financialColorScheme = new FinancialColorSchemeConfig();
    private final Spinner<Double> updatePeriod = new Spinner(1.0, 500.0, 10.0, 1.0);
    private final CheckBox localRange = new CheckBox("auto-y");
    private boolean timerActivated = false;

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        this.configureApp();
        Scene scene = this.prepareScene();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(this::closeDemo);
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
        this.stopTimer();
    }

    protected void configureApp() {
    }

    protected void closeDemo(WindowEvent evt) {
        if (evt.getEventType().equals(WindowEvent.WINDOW_CLOSE_REQUEST) && LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().log("requested demo to shut down");
        }
        this.stopTimer();
        Platform.exit();
    }

    protected ToolBar getTestToolBar(Chart chart, AbstractFinancialRenderer<?> renderer, boolean replaySupport) {
        ToolBar testVariableToolBar = new ToolBar();
        this.localRange.setSelected(renderer.computeLocalRange());
        this.localRange.setTooltip(new Tooltip("select for auto-adjusting min/max the y-axis (prices)"));
        this.localRange.selectedProperty().bindBidirectional((Property)renderer.computeLocalRangeProperty());
        this.localRange.selectedProperty().addListener((ch, old, selection) -> {
            for (ChartPlugin plugin : chart.getPlugins()) {
                if (!(plugin instanceof Zoomer)) continue;
                ((Zoomer)plugin).setAxisMode(selection != false ? AxisMode.X : AxisMode.XY);
            }
            chart.requestLayout();
        });
        Button periodicTimer = null;
        if (replaySupport) {
            periodicTimer = new Button("replay");
            periodicTimer.setTooltip(new Tooltip("replay instrument data in realtime"));
            periodicTimer.setOnAction(evt -> this.pauseResumeTimer());
            this.updatePeriod.valueProperty().addListener((ch, o, n) -> this.updateTimer());
            this.updatePeriod.setEditable(true);
            this.updatePeriod.setPrefWidth(80.0);
        }
        ProfilerInfoBox profilerInfoBox = new ProfilerInfoBox(this.DEBUG_UPDATE_RATE);
        profilerInfoBox.setDebugLevel(ProfilerInfoBox.DebugLevel.VERSION);
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        if (replaySupport) {
            testVariableToolBar.getItems().addAll((Object[])new Node[]{this.localRange, periodicTimer, this.updatePeriod, new Label("[multiply]"), spacer, profilerInfoBox});
        } else {
            testVariableToolBar.getItems().addAll((Object[])new Node[]{this.localRange, spacer, profilerInfoBox});
        }
        return testVariableToolBar;
    }

    protected Scene prepareScene() {
        FlowPane root = new FlowPane();
        root.setAlignment(Pos.CENTER);
        Object[] charts = (Chart[])Arrays.stream(FinancialColorSchemeConstants.getDefaultColorSchemes()).map(this::getDefaultFinancialTestChart).toArray(Chart[]::new);
        root.getChildren().addAll(charts);
        return new Scene((Parent)root, (double)this.prefSceneWidth, (double)this.prefSceneHeight);
    }

    protected Chart getDefaultFinancialTestChart(String theme) {
        DefaultDataSet indiSet = null;
        if (this.resource.startsWith("REALTIME")) {
            try {
                Interval<Calendar> timeRangeInt = CalendarUtils.createByDateTimeInterval(this.timeRange);
                Interval<Calendar> ttInt = CalendarUtils.createByTimeInterval(this.tt);
                Calendar replayFromCal = CalendarUtils.createByDateTime(this.replayFrom);
                this.ohlcvDataSet = new SimpleOhlcvReplayDataSet(SimpleOhlcvReplayDataSet.DataInput.valueOf(this.resource.substring("REALTIME-".length())), this.period, timeRangeInt, ttInt, replayFromCal, this.consolidationAddons);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        this.ohlcvDataSet = new OhlcvDataSet(this.resource);
        indiSet = new DefaultDataSet("MA(24)");
        try {
            this.loadTestData(this.resource, this.ohlcvDataSet, indiSet);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("time", "iso");
        xAxis1.setOverlapPolicy(AxisLabelOverlapPolicy.SKIP_ALT);
        xAxis1.setAutoRangeRounding(false);
        xAxis1.setTimeAxis(true);
        if (xAxis1.isTimeAxis() && xAxis1.getAxisLabelFormatter() instanceof DefaultTimeFormatter) {
            DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)xAxis1.getAxisLabelFormatter();
            axisFormatter.setTimeZoneOffset(ZoneOffset.ofHoursMinutes(2, 0));
        }
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("price", "points");
        XYChart chart = new XYChart(new Axis[]{xAxis1, yAxis1});
        chart.setTitle(theme);
        chart.setLegendVisible(true);
        chart.setPrefSize((double)this.prefChartWidth, (double)this.prefChartHeight);
        chart.setAnimated(false);
        chart.getPlugins().add((Object)new Zoomer(AxisMode.X));
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.getGridRenderer().setDrawOnTop(false);
        yAxis1.setAutoRangeRounding(true);
        yAxis1.setSide(Side.RIGHT);
        this.prepareRenderers(chart, this.ohlcvDataSet, indiSet);
        this.applyColorScheme(theme, chart);
        if (this.timeRange != null) {
            this.showPredefinedTimeRange(this.timeRange, this.ohlcvDataSet, xAxis1, yAxis1);
        }
        return chart;
    }

    protected void applyColorScheme(String theme, XYChart chart) {
        try {
            this.financialColorScheme.applyTo(theme, chart);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected void showPredefinedTimeRange(String dateIntervalPattern, OhlcvDataSet ohlcvDataSet, DefaultNumericAxis xaxis, DefaultNumericAxis yaxis) {
        try {
            Interval<Calendar> fromTo = CalendarUtils.createByDateTimeInterval(dateIntervalPattern);
            double fromTime = (double)((Calendar)fromTo.from).getTime().getTime() / 1000.0;
            double toTime = (double)((Calendar)fromTo.to).getTime().getTime() / 1000.0;
            int fromIdx = ohlcvDataSet.getXIndex(fromTime);
            int toIdx = ohlcvDataSet.getXIndex(toTime);
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (int i = fromIdx; i <= toIdx; ++i) {
                IOhlcvItem ohlcvItem = ohlcvDataSet.getItem(i);
                if (max < ohlcvItem.getHigh()) {
                    max = ohlcvItem.getHigh();
                }
                if (!(min > ohlcvItem.getLow())) continue;
                min = ohlcvItem.getLow();
            }
            xaxis.set(fromTime, toTime);
            yaxis.set(min, max);
            xaxis.setAutoRanging(false);
            yaxis.setAutoRanging(false);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected void loadTestData(String data, OhlcvDataSet dataSet, DefaultDataSet indiSet) throws IOException {
        long startTime = ProcessingProfiler.getTimeStamp();
        IOhlcv ohlcv = new SimpleOhlcvDailyParser().getContinuousOHLCV(data);
        dataSet.autoNotification().set(false);
        dataSet.setData(ohlcv);
        dataSet.autoNotification().set(true);
        DescriptiveStatistics stats = new DescriptiveStatistics(24);
        for (IOhlcvItem ohlcvItem : ohlcv) {
            double timestamp = (double)ohlcvItem.getTimeStamp().getTime() / 1000.0;
            stats.addValue(ohlcvItem.getClose());
            indiSet.add(timestamp, stats.getMean());
        }
        Platform.runLater(() -> dataSet.fireInvalidated(null));
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    protected abstract void prepareRenderers(XYChart var1, OhlcvDataSet var2, DefaultDataSet var3);

    private void pauseResumeTimer() {
        if (!this.timerActivated) {
            this.startTimer();
        } else if (this.ohlcvDataSet instanceof SimpleOhlcvReplayDataSet) {
            ((SimpleOhlcvReplayDataSet)this.ohlcvDataSet).pauseResume();
        }
    }

    private void updateTimer() {
        if (this.timerActivated) {
            this.startTimer();
        }
    }

    private void startTimer() {
        if (this.ohlcvDataSet instanceof SimpleOhlcvReplayDataSet) {
            SimpleOhlcvReplayDataSet realtimeDataSet = (SimpleOhlcvReplayDataSet)this.ohlcvDataSet;
            realtimeDataSet.setUpdatePeriod((Double)this.updatePeriod.getValue());
            this.timerActivated = true;
        }
    }

    private void stopTimer() {
        if (this.timerActivated && this.ohlcvDataSet instanceof SimpleOhlcvReplayDataSet) {
            this.timerActivated = false;
            SimpleOhlcvReplayDataSet realtimeDataSet = (SimpleOhlcvReplayDataSet)this.ohlcvDataSet;
            realtimeDataSet.stop();
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

