/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.legacy;

import de.gsi.chart.samples.RollingBufferSample;
import de.gsi.chart.samples.legacy.MultipleAxesLineChart;
import de.gsi.chart.utils.SimplePerformanceMeter;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.StringConverter;

@Deprecated
public class RollingBufferLegacySample
extends Application {
    private static final int MAX_DATA_POINTS = 750;
    private static final int UPDATE_PERIOD = RollingBufferSample.UPDATE_PERIOD;
    private Timer timer;
    private final XYChart.Series<Number, Number> series1 = new XYChart.Series();
    private final XYChart.Series<Number, Number> series2 = new XYChart.Series();
    private NumberAxis xAxis;

    private HBox getHeaderBar(Scene scene) {
        final AddToQueue addToQueue = new AddToQueue();
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)addToQueue));
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            this.series1.getData().clear();
            this.series2.getData().clear();
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        Platform.runLater((Runnable)addToQueue);
                    }
                }, 0L, (long)UPDATE_PERIOD);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SimplePerformanceMeter meter = new SimplePerformanceMeter(scene, 500L);
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)"Monospaced", (double)12.0));
        meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            String fxRate = String.format("%4.1f", meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", meter.getSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s %s", "JavaFX", fxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s %s", "Actual", actualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s %s", "Process-CPU", cpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s %s", "System -CPU", cpuSystem, "%"));
        });
        return new HBox(new Node[]{newDataSet, startTimer, spacer, new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }

    private void init(Stage primaryStage) {
        BorderPane root = new BorderPane();
        this.xAxis = new NumberAxis(0.0, 750.0, (double)(750 * UPDATE_PERIOD / 20000));
        this.xAxis.setForceZeroInRange(false);
        this.xAxis.setAutoRanging(false);
        this.xAxis.setTickLabelRotation(45.0);
        final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        this.xAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public Number fromString(String string) {
                return null;
            }

            public String toString(Number utcValueSeconds) {
                long longUTCSeconds = utcValueSeconds.longValue();
                int longNanoSeconds = (int)((utcValueSeconds.doubleValue() - (double)longUTCSeconds) * 1.0E9);
                LocalDateTime dateTime = LocalDateTime.ofEpochSecond(longUTCSeconds, longNanoSeconds, ZoneOffset.UTC);
                String computed = dateTime.format(formatter).replaceAll(" ", System.lineSeparator());
                return computed;
            }
        });
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){
            final DecimalFormat formatter = new DecimalFormat("0.##E0");

            public Number fromString(String string) {
                return null;
            }

            public String toString(Number object) {
                return this.formatter.format(object.doubleValue());
            }
        });
        LineChart<Number, Number> lineChart = new LineChart<Number, Number>((Axis)this.xAxis, (Axis)yAxis){

            protected void dataItemAdded(XYChart.Series<Number, Number> series, int itemIndex, XYChart.Data<Number, Number> item) {
            }
        };
        lineChart.setAnimated(false);
        lineChart.setHorizontalGridLinesVisible(true);
        lineChart.setVerticalGridLinesVisible(true);
        lineChart.setCreateSymbols(false);
        lineChart.getXAxis().setLabel("time");
        lineChart.getXAxis().setAnimated(false);
        lineChart.getYAxis().setLabel("beam intensity [ppp]");
        lineChart.getYAxis().setAnimated(false);
        lineChart.setStyle(".chart-series-line {-fx-stroke-width: 0.5px;}");
        lineChart.setStyle(".default-color0.chart-series-line { -fx-stroke: blue; -fx-stroke-width: 1px;}");
        this.series1.setName("beam intensity [ppp]");
        this.series2.setName("dipole current [A]");
        lineChart.getData().add(this.series1);
        MultipleAxesLineChart chart = new MultipleAxesLineChart(lineChart, Color.BLUE.darker(), 1.5);
        chart.addSeries(this.series2, Color.RED.darker());
        Scene scene = new Scene((Parent)root, 1800.0, 400.0);
        scene.getStylesheets().add((Object)Objects.requireNonNull(RollingBufferLegacySample.class.getResource("RollingBufferLegacy.css")).toExternalForm());
        HBox header = this.getHeaderBar(scene);
        root.setCenter((Node)chart);
        root.setTop((Node)header);
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> new AddToQueue().run());
            }
        }, 0L, (long)UPDATE_PERIOD);
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public void start(Stage stage) {
        stage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        this.init(stage);
        stage.show();
    }

    public static void main(String[] args) {
        RollingBufferLegacySample.launch((String[])args);
    }

    private class AddToQueue
    implements Runnable {
        private AddToQueue() {
        }

        @Override
        public void run() {
            double now;
            double t = now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
            double y1 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
            double y2 = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
            RollingBufferLegacySample.this.series1.getData().add((Object)new XYChart.Data((Object)now, (Object)y1));
            RollingBufferLegacySample.this.series2.getData().add((Object)new XYChart.Data((Object)now, (Object)y2));
            while (RollingBufferLegacySample.this.series1.getData().size() > 750) {
                RollingBufferLegacySample.this.series1.getData().remove(0, RollingBufferLegacySample.this.series1.getData().size() - 750);
            }
            while (RollingBufferLegacySample.this.series2.getData().size() > 750) {
                RollingBufferLegacySample.this.series2.getData().remove(0, RollingBufferLegacySample.this.series2.getData().size() - 750);
            }
            RollingBufferLegacySample.this.xAxis.setLowerBound(now - (double)(750 * UPDATE_PERIOD) / 1000.0 * 1.01);
            RollingBufferLegacySample.this.xAxis.setUpperBound(now);
        }
    }
}

