/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.YWatchValueIndicator;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.testdata.spi.CosineFunction;
import de.gsi.dataset.testdata.spi.SineFunction;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Duration;

public class YWatchValueIndicatorSample
extends Application {
    private static final int N_SAMPLES = 1000;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis();
        yAxis2.setSide(Side.RIGHT);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        root.getChildren().add((Object)chart);
        chart.getAxes().add((Object)yAxis2);
        chart.getDatasets().addAll((Object[])new DataSet[]{new SineFunction("sine", 1000), new CosineFunction("cosine", 1000)});
        YWatchValueIndicator indicator1 = new YWatchValueIndicator((Axis)yAxis, 0.7);
        indicator1.setId("valA");
        final YWatchValueIndicator indicator2 = new YWatchValueIndicator((Axis)yAxis, 0.63);
        indicator2.setId("valB");
        YWatchValueIndicator indicator3 = new YWatchValueIndicator((Axis)yAxis2, 0.18);
        indicator3.setId("valA");
        indicator3.setPreventOcclusion(true);
        final YWatchValueIndicator indicator4 = new YWatchValueIndicator((Axis)yAxis2, 0.2);
        indicator4.setId("valB");
        YWatchValueIndicator indicator5 = new YWatchValueIndicator((Axis)yAxis2, 0.21);
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{indicator1, indicator2, indicator3, indicator4, indicator5});
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)20.0), (EventHandler)new EventHandler<ActionEvent>(){
            double time = 0.0;

            public void handle(ActionEvent t) {
                this.time += 0.03;
                indicator2.setValue(0.65 + 0.14 * Math.cos(this.time));
                indicator4.setValue(0.21 + 0.18 * Math.cos(0.8 * this.time));
            }
        }, new KeyValue[0])});
        timeline.setCycleCount(-1);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        scene.getStylesheets().add((Object)Objects.requireNonNull(YWatchValueIndicatorSample.class.getResource("YWatchValueIndicatorSample.css"), "stylesheet not found").toExternalForm());
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        timeline.play();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

