/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ColormapSelector;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ContourType;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.datareduction.ReductionType;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.samples.utils.TestDataSetSource;
import de.gsi.chart.ui.ProfilerInfoBox;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterfallPerformanceSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterfallPerformanceSample.class);
    private static final int DEBUG_UPDATE_RATE = 500;
    private static final int UPDATE_PERIOD = 40;
    private static final int INITIAL_FRAME_SIZE = 1024;
    private static final int INITIAL_FRAME_COUNT = 1000;
    private final Spinner<Integer> updatePeriod = new Spinner(10, 1000, 40, 10);
    private final Spinner<Integer> frameSize = new Spinner(4, 100000, 1024, 128);
    private final Spinner<Integer> frameCount = new Spinner(2, 100000, 1000, 100);
    private final ComboBox<TestDataSetSource.DataInput> inputSource = new ComboBox(FXCollections.observableArrayList((Object[])TestDataSetSource.DataInput.values()));
    private final CheckBox mute = new CheckBox("mute");
    private final ComboBox<ContourType> contourType = new ComboBox();
    private final ColormapSelector.ColormapComboBox colorGradient = new ColormapSelector.ColormapComboBox();
    private final Slider nCountourLevelSlider = new Slider(0.0, 100.0, 20.0);
    private final CheckBox localRange = new CheckBox("auto-z");
    private final Slider nSegmentSlider = new Slider(0.0, 10000.0, 500.0);
    private final Slider minHexSizeSlider = new Slider(3.0, 25.0, 5.0);
    private final CheckBox dataReduction = new CheckBox("data reduction");
    private final Spinner<Integer> reductionFactorX = new Spinner(0, 100, 1, 1);
    private final Spinner<Integer> reductionFactorY = new Spinner(0, 100, 1, 1);
    private final ComboBox<ReductionType> reductionType = new ComboBox();
    private final CheckBox smooth = new CheckBox("smooth");
    private final CheckBox altImplementation = new CheckBox("alt impl.");
    private final CheckBox parallelImplementation = new CheckBox("parallel impl.");
    private final TestDataSetSource dataSet = new TestDataSetSource();
    private Timer timer;

    private void closeDemo(WindowEvent evt) {
        if (evt.getEventType().equals(WindowEvent.WINDOW_CLOSE_REQUEST) && LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().log("requested demo to shut down");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.dataSet.stop();
        }
        Platform.exit();
    }

    private XYChart getChartPane(ContourType colorMap) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setAnimated(false);
        xAxis.setAutoRangeRounding(false);
        xAxis.setName("X Position");
        xAxis.setAutoRanging(true);
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setAnimated(false);
        yAxis.setAutoRangeRounding(false);
        yAxis.setName("Y Position");
        yAxis.setAutoRanging(true);
        DefaultNumericAxis zAxis = new DefaultNumericAxis();
        zAxis.setAnimated(false);
        zAxis.setAutoRangeRounding(false);
        zAxis.setName("z Amplitude");
        zAxis.setAutoRanging(true);
        zAxis.setSide(Side.RIGHT);
        zAxis.getProperties().put((Object)"OmitAxisZoom", (Object)true);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.getAxes().add((Object)zAxis);
        chart.setTitle("press 'timer', feel free to whistle and play with the contour and data reduction parameters");
        chart.setAnimated(false);
        chart.getRenderers().clear();
        chart.setLegendVisible(false);
        ContourDataSetRenderer contourRenderer = new ContourDataSetRenderer();
        contourRenderer.getAxes().addAll((Object[])new Axis[]{xAxis, yAxis, zAxis});
        chart.getRenderers().setAll((Object[])new Renderer[]{contourRenderer});
        contourRenderer.setContourType(colorMap);
        contourRenderer.getDatasets().add((Object)this.dataSet);
        Zoomer zoomer = new Zoomer();
        zoomer.setAutoZoomEnabled(true);
        zoomer.setAddButtonsToToolBar(true);
        chart.getPlugins().add((Object)zoomer);
        chart.getPlugins().add((Object)new EditAxis());
        HBox.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        return chart;
    }

    private ToolBar getContourToolBar(XYChart chart, ContourDataSetRenderer renderer) {
        ToolBar contourToolBar = new ToolBar();
        this.contourType.getItems().addAll((Object[])ContourType.values());
        this.contourType.setValue((Object)renderer.getContourType());
        this.contourType.valueProperty().bindBidirectional((Property)renderer.contourTypeProperty());
        this.contourType.valueProperty().addListener((ch, old, selection) -> chart.requestLayout());
        this.colorGradient.setValue((Object)renderer.getColorGradient());
        this.colorGradient.valueProperty().bindBidirectional((Property)renderer.colorGradientProperty());
        this.colorGradient.valueProperty().addListener((ch, old, selection) -> chart.requestLayout());
        this.nCountourLevelSlider.setShowTickLabels(true);
        this.nCountourLevelSlider.setShowTickMarks(true);
        this.nCountourLevelSlider.setMajorTickUnit(10.0);
        this.nCountourLevelSlider.setMinorTickCount(5);
        this.nCountourLevelSlider.setBlockIncrement(1.0);
        this.nCountourLevelSlider.setTooltip(new Tooltip("adjusts number of contour levels"));
        HBox.setHgrow((Node)this.nCountourLevelSlider, (Priority)Priority.ALWAYS);
        Label nContourLabel = new Label("n contours:");
        nContourLabel.setTooltip(new Tooltip("adjusts number of contour levels"));
        HBox hBoxContourLevelSlider = new HBox(new Node[]{nContourLabel, this.nCountourLevelSlider});
        this.nCountourLevelSlider.valueProperty().bindBidirectional((Property)renderer.quantisationLevelsProperty());
        this.nCountourLevelSlider.valueProperty().addListener((ch, o, n) -> chart.requestLayout());
        this.nSegmentSlider.setShowTickLabels(true);
        this.nSegmentSlider.setShowTickMarks(true);
        this.nSegmentSlider.setMajorTickUnit(200.0);
        this.nSegmentSlider.setMinorTickCount(50);
        this.nSegmentSlider.setBlockIncrement(10.0);
        HBox.setHgrow((Node)this.nSegmentSlider, (Priority)Priority.ALWAYS);
        HBox hBoxSegmentSlider = new HBox(new Node[]{new Label("n segments :"), this.nSegmentSlider});
        this.nSegmentSlider.valueProperty().bindBidirectional((Property)renderer.maxContourSegmentsProperty());
        this.nSegmentSlider.valueProperty().addListener((ch, o, n) -> chart.requestLayout());
        this.minHexSizeSlider.setShowTickLabels(true);
        this.minHexSizeSlider.setShowTickMarks(true);
        this.minHexSizeSlider.setMajorTickUnit(10.0);
        this.minHexSizeSlider.setMinorTickCount(10);
        this.minHexSizeSlider.setBlockIncrement(1.0);
        HBox.setHgrow((Node)this.minHexSizeSlider, (Priority)Priority.ALWAYS);
        HBox hBoxHexSizeSlider = new HBox(new Node[]{new Label("HexSize :"), this.minHexSizeSlider});
        this.minHexSizeSlider.valueProperty().bindBidirectional((Property)renderer.minHexTileSizeProperty());
        this.minHexSizeSlider.valueProperty().addListener((ch, o, n) -> chart.requestLayout());
        this.localRange.setSelected(renderer.computeLocalRange());
        this.localRange.setTooltip(new Tooltip("select for auto-adjusting the colour axis for the selected sub-range"));
        this.localRange.selectedProperty().bindBidirectional((Property)renderer.computeLocalRangeProperty());
        this.localRange.selectedProperty().addListener((ch, old, selection) -> chart.requestLayout());
        ToolBar standardCountourParameters = new ToolBar(new Node[]{this.contourType, this.colorGradient, hBoxContourLevelSlider, hBoxSegmentSlider, hBoxHexSizeSlider, this.localRange});
        this.dataReduction.setSelected(renderer.isReducePoints());
        this.dataReduction.selectedProperty().bindBidirectional((Property)renderer.pointReductionProperty());
        this.dataReduction.selectedProperty().addListener((ch, old, selection) -> chart.requestLayout());
        ChangeListener reductionListener = (ch, o, n) -> {
            renderer.setReductionFactorX(((Integer)this.reductionFactorX.getValue()).intValue());
            renderer.setReductionFactorY(((Integer)this.reductionFactorY.getValue()).intValue());
            chart.requestLayout();
        };
        this.reductionFactorX.getValueFactory().setValue((Object)renderer.getReductionFactorX());
        this.reductionFactorY.getValueFactory().setValue((Object)renderer.getReductionFactorY());
        this.reductionFactorX.setPrefWidth(80.0);
        this.reductionFactorY.setPrefWidth(80.0);
        this.reductionFactorX.valueProperty().addListener(reductionListener);
        this.reductionFactorY.valueProperty().addListener(reductionListener);
        HBox.setHgrow(this.reductionFactorX, (Priority)Priority.ALWAYS);
        HBox.setHgrow(this.reductionFactorY, (Priority)Priority.ALWAYS);
        HBox hBoxReductionFactorSlider = new HBox(new Node[]{new Label("Min Data Pixel Size X:"), this.reductionFactorX, new Label(" Y:"), this.reductionFactorY});
        this.reductionType.getItems().addAll((Object[])ReductionType.values());
        this.reductionType.setValue((Object)renderer.getReductionType());
        this.reductionType.valueProperty().bindBidirectional((Property)renderer.reductionTypeProperty());
        this.reductionType.valueProperty().addListener((ch, old, selection) -> chart.requestLayout());
        this.smooth.setSelected(renderer.isSmooth());
        this.smooth.selectedProperty().bindBidirectional((Property)renderer.smoothProperty());
        this.smooth.selectedProperty().addListener((ch, old, selection) -> chart.requestLayout());
        this.altImplementation.setSelected(renderer.isAltImplementation());
        this.altImplementation.selectedProperty().bindBidirectional((Property)renderer.altImplementationProperty());
        this.altImplementation.selectedProperty().addListener((ch, old, selection) -> chart.requestLayout());
        this.parallelImplementation.setSelected(renderer.isParallelImplementation());
        this.parallelImplementation.selectedProperty().bindBidirectional((Property)renderer.parallelImplementationProperty());
        this.parallelImplementation.selectedProperty().addListener((ch, old, selection) -> chart.requestLayout());
        ToolBar newCountourParameters = new ToolBar(new Node[]{this.dataReduction, hBoxReductionFactorSlider, this.reductionType, this.smooth, this.altImplementation, this.parallelImplementation});
        contourToolBar.getItems().addAll((Object[])new Node[]{new VBox(new Node[]{standardCountourParameters, newCountourParameters})});
        return contourToolBar;
    }

    private ToolBar getDataSetToolBar(Chart chart) {
        ToolBar dataSetToolBar = new ToolBar();
        this.inputSource.getSelectionModel().select(0);
        this.inputSource.getSelectionModel().selectedItemProperty().addListener((ch, o, n) -> this.dataSet.setInputSource((TestDataSetSource.DataInput)((Object)n)));
        this.frameSize.valueProperty().addListener((ch, o, n) -> this.updateTimer(true));
        this.frameSize.setEditable(true);
        this.frameSize.setPrefWidth(80.0);
        this.frameCount.valueProperty().addListener((ch, o, n) -> this.updateTimer(true));
        this.frameCount.setEditable(true);
        this.frameCount.setPrefWidth(80.0);
        Label canvasDimension = new Label();
        ChangeListener canvasListener = (ch, o, n) -> canvasDimension.setText("canvas = " + chart.getCanvas().getWidth() + " x " + chart.getCanvas().getHeight() + " pixels");
        Label dataSetDimension = new Label();
        dataSetDimension.setText(this.dataSet.getShape(0) + " x " + this.dataSet.getShape(1) + " data points");
        this.dataSet.addListener(evt -> {
            int dimX = this.dataSet.getShape(0);
            int dimY = this.dataSet.getShape(1);
            Platform.runLater(() -> {
                dataSetDimension.setText(dimX + " x " + dimY + " data points");
                canvasDimension.setText("canvas = " + chart.getCanvas().getWidth() + " x " + chart.getCanvas().getHeight() + " pixels");
            });
        });
        this.mute.setSelected(this.dataSet.isOutputMuted());
        this.mute.selectedProperty().addListener((ch, o, n) -> this.dataSet.setOutputMuted((boolean)n));
        canvasListener.changed(null, null, null);
        chart.widthProperty().addListener(canvasListener);
        chart.heightProperty().addListener(canvasListener);
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        dataSetToolBar.getItems().addAll((Object[])new Node[]{new Label("DataSet Settings:"), new Label("input source:"), this.inputSource, new Label("frame size:"), this.frameSize, new Label("frame count:"), this.frameCount, this.mute, spacer, new HBox(new Node[]{canvasDimension, dataSetDimension})});
        return dataSetToolBar;
    }

    private ToolBar getTestToolBar() {
        ToolBar testVariableToolBar = new ToolBar();
        Button fillDataSet = new Button("fill");
        fillDataSet.setTooltip(new Tooltip("update data set with demo data"));
        fillDataSet.setOnAction(evt -> this.dataSet.fillTestData());
        Button stepDataSet = new Button("step");
        stepDataSet.setTooltip(new Tooltip("update data set by one row"));
        stepDataSet.setOnAction(evt -> this.dataSet.step());
        Button periodicTimer = new Button("timer");
        periodicTimer.setTooltip(new Tooltip("update data set periodically"));
        periodicTimer.setOnAction(evt -> this.updateTimer(false));
        this.updatePeriod.valueProperty().addListener((ch, o, n) -> this.updateTimer(true));
        this.updatePeriod.setEditable(true);
        this.updatePeriod.setPrefWidth(80.0);
        ProfilerInfoBox profilerInfoBox = new ProfilerInfoBox(500);
        profilerInfoBox.setDebugLevel(ProfilerInfoBox.DebugLevel.VERSION);
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        testVariableToolBar.getItems().addAll((Object[])new Node[]{fillDataSet, stepDataSet, periodicTimer, this.updatePeriod, new Label("[ms]"), spacer, profilerInfoBox});
        return testVariableToolBar;
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setDebugState((boolean)false);
        ProcessingProfiler.setLoggerOutputState((boolean)false);
        VBox root = new VBox();
        Scene scene = new Scene((Parent)root, 1150.0, 800.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(this::closeDemo);
        ToolBar testVariableToolBar = this.getTestToolBar();
        XYChart chart = this.getChartPane(ContourType.HEATMAP);
        VBox.setVgrow((Node)chart, (Priority)Priority.SOMETIMES);
        ToolBar dataSetToolBar = this.getDataSetToolBar((Chart)chart);
        ContourDataSetRenderer renderer = (ContourDataSetRenderer)chart.getRenderers().get(0);
        ToolBar contourToolBar = this.getContourToolBar(chart, renderer);
        root.getChildren().addAll((Object[])new Node[]{testVariableToolBar, chart, contourToolBar, dataSetToolBar});
    }

    private void updateTimer(boolean restart) {
        if (this.timer != null) {
            this.timer.cancel();
            this.dataSet.stop();
            this.timer = null;
            if (!restart) {
                return;
            }
        } else if (restart) {
            return;
        }
        this.timer = new Timer("sample-update-timer", true);
        int period = (Integer)this.updatePeriod.getValue();
        int localFrameSize = (Integer)this.frameSize.getValue();
        int localFrameCount = (Integer)this.frameCount.getValue();
        this.dataSet.setUpdatePeriod(period);
        this.dataSet.setFrameSize(localFrameSize);
        this.dataSet.setFrameCount(localFrameCount);
        this.dataSet.start();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

