/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityToggleSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisibilityToggleSample.class);
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        XYChart chart = new XYChart();
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new EditAxis()});
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1");
        DoubleDataSet dataSet2 = new DoubleDataSet("data set #2");
        dataSet1.addListener(evt -> LOGGER.atInfo().log("dataSet1 - event: " + evt.toString()));
        dataSet2.addListener(evt -> LOGGER.atInfo().log("dataSet2 - event: " + evt.toString()));
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        double[] xValues = new double[100];
        double[] yValues1 = new double[100];
        dataSet2.autoNotification().set(false);
        for (int n = 0; n < 100; ++n) {
            double x = n;
            double y1 = Math.cos(Math.toRadians(10.0 * (double)n));
            double y2 = Math.sin(Math.toRadians(10.0 * (double)n));
            xValues[n] = x;
            yValues1[n] = y1;
            dataSet2.add((double)n, y2);
        }
        dataSet1.set(xValues, yValues1);
        dataSet2.autoNotification().set(true);
        dataSet2.invokeListener((UpdateEvent)new UpdatedDataEvent((EventSource)dataSet2, "manual update event"));
        BorderPane borderPane = new BorderPane((Node)chart);
        HBox toolbar = new HBox();
        CheckBox visibility1 = new CheckBox("show Dataset 1");
        visibility1.setSelected(true);
        visibility1.selectedProperty().addListener((observable, oldValue, newValue) -> dataSet1.setVisible(newValue.booleanValue()));
        dataSet1.addListener(event -> {
            if (event instanceof UpdatedMetaDataEvent) {
                FXUtils.runFX(() -> visibility1.setSelected(dataSet1.isVisible()));
            }
        });
        CheckBox visibility2 = new CheckBox("show Dataset 2");
        visibility2.setSelected(true);
        visibility2.selectedProperty().addListener((observable, oldValue, newValue) -> dataSet2.setVisible(newValue.booleanValue()));
        dataSet2.addListener(event -> {
            if (event instanceof UpdatedMetaDataEvent) {
                FXUtils.runFX(() -> visibility2.setSelected(dataSet2.isVisible()));
            }
        });
        toolbar.getChildren().addAll((Object[])new Node[]{visibility1, visibility2});
        borderPane.setTop((Node)toolbar);
        Scene scene = new Scene((Parent)borderPane, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

