/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.util.Objects;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class ValueIndicatorSample
extends Application {
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        root.getChildren().add((Object)chart);
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1");
        DoubleDataSet dataSet2 = new DoubleDataSet("data set #2");
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        double[] xValues = new double[100];
        double[] yValues1 = new double[100];
        double[] yValues2 = new double[100];
        for (int n = 0; n < 100; ++n) {
            xValues[n] = n;
            yValues1[n] = Math.cos(Math.toRadians(10.0 * (double)n));
            yValues2[n] = Math.sin(Math.toRadians(10.0 * (double)n));
        }
        dataSet1.set(xValues, yValues1);
        dataSet2.set(xValues, yValues2);
        XValueIndicator xValueIndicator = new XValueIndicator((Axis)xAxis, 20.0, "x-indicator");
        chart.getStylesheets().add((Object)Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("ValueIndicatorSample.css")).toExternalForm());
        chart.getPlugins().add((Object)xValueIndicator);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

