/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.UpdateAxisLabels;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.spi.TransposedDataSet;
import java.util.Arrays;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransposedDataSetSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransposedDataSetSample.class);
    protected static final int FONT_SIZE = 20;
    protected static final String FONT_SYMBOL_TRANSPOSE = "fas-sync:20";
    protected static final String FONT_SYMBOL_CHECK = "fa-check-circle:20";
    private static final int N_SAMPLES = 1000;
    private static final int N_TURNS = 20;

    public void start(Stage primaryStage) {
        XYChart chart1 = TransposedDataSetSample.getDefaultChart();
        ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)chart1.getRenderers().get(0);
        renderer.setAssumeSortedData(false);
        DataSet dataSet1 = TransposedDataSetSample.test8Function(0.0, 4.0, -1.0, 3.0, 0.12566370614359174, 0.2, 1000);
        TransposedDataSet transposedDataSet1 = TransposedDataSet.transpose((DataSet)dataSet1, (boolean)false);
        renderer.getDatasets().add((Object)transposedDataSet1);
        XYChart chart2 = TransposedDataSetSample.getDefaultChart();
        ContourDataSetRenderer contourRenderer = new ContourDataSetRenderer();
        chart2.getRenderers().setAll((Object[])new Renderer[]{contourRenderer});
        DataSet dataSet2 = TransposedDataSetSample.createTestData();
        dataSet2.getAxisDescription(0).set("time", new String[]{"s"});
        dataSet2.getAxisDescription(1).set("position", new String[]{"m"});
        TransposedDataSet transposedDataSet2 = TransposedDataSet.transpose((DataSet)dataSet2, (boolean)false);
        contourRenderer.getDatasets().add((Object)transposedDataSet2);
        CheckBox cbTransposed = new CheckBox("flip data set");
        TextField textPermutation = new TextField("0,1,2");
        textPermutation.setPrefWidth(100.0);
        cbTransposed.setTooltip(new Tooltip("press to transpose DataSet"));
        cbTransposed.setGraphic((Node)new FontIcon(FONT_SYMBOL_TRANSPOSE));
        Button bApplyPermutation = new Button(null, (Node)new FontIcon(FONT_SYMBOL_CHECK));
        bApplyPermutation.setTooltip(new Tooltip("press to apply permutation"));
        cbTransposed.setOnAction(evt -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.atInfo().addArgument((Object)cbTransposed.isSelected()).log("set transpose state to '{}'");
            }
            transposedDataSet1.setTransposed(cbTransposed.isSelected());
            transposedDataSet2.setTransposed(cbTransposed.isSelected());
            textPermutation.setText(Arrays.stream(transposedDataSet2.getPermutation()).boxed().map(String::valueOf).collect(Collectors.joining(",")));
        });
        Runnable permutationAction = () -> {
            int[] parsedInt1 = Arrays.asList(textPermutation.getText().split(",")).subList(0, transposedDataSet1.getDimension()).stream().map(String::trim).mapToInt(Integer::parseInt).toArray();
            int[] parsedInt2 = Arrays.asList(textPermutation.getText().split(",")).subList(0, transposedDataSet2.getDimension()).stream().map(String::trim).mapToInt(Integer::parseInt).toArray();
            transposedDataSet1.setPermutation(parsedInt1);
            transposedDataSet2.setPermutation(parsedInt2);
        };
        textPermutation.setOnAction(evt -> permutationAction.run());
        bApplyPermutation.setOnAction(evt -> permutationAction.run());
        ToolBar toolBar = new ToolBar(new Node[]{new Label("method #1 - transpose: "), cbTransposed, new Separator(), new Label("method #2 - permutation: "), textPermutation, bApplyPermutation});
        HBox hBox = new HBox(new Node[]{chart1, chart2});
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        Scene scene = new Scene((Parent)new VBox(new Node[]{toolBar, hBox}), 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    private static DataSet createTestData() {
        double val;
        int i;
        int nPoints = 300;
        double f = 0.1;
        double[] x = new double[300];
        double[] y = new double[600];
        for (i = 0; i < x.length; ++i) {
            x[i] = val = ((double)i / (double)x.length + 0.5) * 10.0;
        }
        for (i = 0; i < y.length; ++i) {
            y[i] = val = ((double)i / (double)y.length - 0.5) * 10.0;
        }
        double[][] z = new double[y.length][x.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                z[yIndex][xIndex] = x[xIndex] * (y[yIndex] - 3.0) * Math.sin(1.5707963267948966 * x[xIndex]) * Math.cos(0.6283185307179586 * y[yIndex]);
            }
        }
        return new DataSetBuilder("3D test data").setValues(0, x).setValues(1, y).setValues(2, z).build();
    }

    private static XYChart getDefaultChart() {
        XYChart chart = new XYChart();
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new UpdateAxisLabels());
        chart.getXAxis().setAutoRanging(true);
        chart.getYAxis().setAutoRanging(true);
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public static DataSet test8Function(double xMin, double xMax, double yMin, double yMax, double omega, double pert, int nSamples) {
        double[] x = new double[nSamples];
        double[] y = new double[nSamples];
        double a = (xMax - xMin) / 2.0;
        double b = (yMax - yMin) / 2.0;
        for (int i = 0; i < nSamples; ++i) {
            x[i] = xMin + a * (Math.sin((double)i * omega) + 1.0) + pert * Math.sin((double)i * omega * 0.95) * Math.cos((double)i * omega * 2.0);
            y[i] = yMin + b * (Math.sin((double)i * omega * 2.0) + 1.0) + pert * Math.sin((double)i * omega * 0.777) * Math.cos((double)i * omega);
        }
        DataSet dataSet = new DataSetBuilder().setName("non-sorted 2D DataSet").setValues(0, x).setValues(1, y).build();
        dataSet.getAxisDescription(0).set("position", new String[]{"m"});
        dataSet.getAxisDescription(1).set("velocity", new String[]{"m/s"});
        return dataSet;
    }
}

