/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.LimitedIndexedTreeDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class TimeAxisNonLinearSample
extends Application {
    private static final Timer timer = new Timer();

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1400.0, 600.0);
        NonLinearTimeAxis xAxis1 = new NonLinearTimeAxis("time", "iso");
        xAxis1.setThreshold(0.6);
        xAxis1.setWeight(0.975);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y-axis", "a.u.");
        XYChart chart = new XYChart(new Axis[]{xAxis1, yAxis1});
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.setAnimated(false);
        ((ErrorDataSetRenderer)chart.getRenderers().get(0)).setAllowNaNs(true);
        ((ErrorDataSetRenderer)chart.getRenderers().get(0)).setPointReduction(false);
        yAxis1.setAutoRangeRounding(true);
        final LimitedIndexedTreeDataSet dataSet = new LimitedIndexedTreeDataSet("TestData", 100000, 60.0);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
                dataSet.add(now - dataSet.getMaxLength(), Double.NaN, 0.0, 0.0, new String[0]);
                dataSet.add(now, 100.0 * Math.cos(Math.PI * 2 * now), 0.0, 0.0, new String[0]);
            }
        }, 1000L, 40L);
        long startTime = ProcessingProfiler.getTimeStamp();
        chart.getDatasets().add((Object)dataSet);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        Slider spThreshold = new Slider(0.0, 1.0, xAxis1.getThreshold());
        spThreshold.setMajorTickUnit(0.1);
        spThreshold.setSnapToTicks(true);
        spThreshold.setShowTickLabels(true);
        spThreshold.setShowTickMarks(true);
        HBox.setHgrow((Node)spThreshold, (Priority)Priority.ALWAYS);
        spThreshold.valueProperty().bindBidirectional((Property)xAxis1.thresholdProperty());
        XValueIndicator xValueIndicator = new XValueIndicator((Axis)xAxis1, xAxis1.getWidth() * xAxis1.getThreshold(), "long-short");
        xValueIndicator.setEditable(false);
        dataSet.addListener(evt -> {
            double locator = xAxis1.getValueForDisplay(xAxis1.getThreshold() * xAxis1.getWidth());
            FXUtils.runFX(() -> xValueIndicator.setValue(locator));
        });
        chart.getPlugins().add((Object)xValueIndicator);
        Slider spWeight = new Slider(0.0, 1.0, xAxis1.getWeight());
        spWeight.setMajorTickUnit(0.1);
        spWeight.setShowTickLabels(true);
        spWeight.setSnapToTicks(true);
        spWeight.setShowTickMarks(true);
        HBox.setHgrow((Node)spWeight, (Priority)Priority.ALWAYS);
        spWeight.valueProperty().bindBidirectional((Property)xAxis1.weightProperty());
        root.setTop((Node)new VBox(new Node[]{new HBox(new Node[]{new Label("threshold: "), spThreshold}), new HBox(new Node[]{new Label("weight: "), spWeight})}));
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
        XYChart diagChart = new XYChart();
        diagChart.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new EditAxis(), new DataPointTooltip()});
        DoubleDataSet function = new DoubleDataSet("function");
        DoubleDataSet inverse = new DoubleDataSet("inverse");
        DoubleDataSet identity = new DoubleDataSet("identity");
        diagChart.getDatasets().addAll((Object[])new DataSet[]{function, inverse, identity});
        int nSamples = 1000;
        Runnable updateFunction = () -> {
            function.clearData();
            inverse.clearData();
            identity.clearData();
            for (int i = 0; i < 1000; ++i) {
                double x = (double)i / 999.0;
                function.add(x, NonLinearTimeAxis.forwardTransform(x, xAxis1.getThreshold(), xAxis1.getWeight()));
                inverse.add(x, NonLinearTimeAxis.backwardTransform(x, xAxis1.getThreshold(), xAxis1.getWeight()));
                identity.add(x, NonLinearTimeAxis.backwardTransform(NonLinearTimeAxis.forwardTransform(x, xAxis1.getThreshold(), xAxis1.getWeight()), xAxis1.getThreshold(), xAxis1.getWeight()));
            }
        };
        updateFunction.run();
        spThreshold.valueProperty().addListener(evt -> updateFunction.run());
        spWeight.valueProperty().addListener(evt -> updateFunction.run());
        root.setBottom((Node)diagChart);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public static class NonLinearTimeAxis
    extends DefaultNumericAxis {
        private final transient DoubleProperty threshold = new SimpleDoubleProperty((Object)this, "threshold", 0.6);
        private final transient DoubleProperty weight = new SimpleDoubleProperty((Object)this, "weight", 0.9);
        private final transient DefaultTimeFormatter lowerFormat = new DefaultTimeFormatter();
        private final transient DefaultTimeFormatter upperFormat = new DefaultTimeFormatter();

        NonLinearTimeAxis(String axisLabel, String unit) {
            super(axisLabel, unit);
            this.setOverlapPolicy(AxisLabelOverlapPolicy.SKIP_ALT);
            this.setAutoRangeRounding(false);
            super.setTimeAxis(true);
        }

        public double getDisplayPosition(double value) {
            double diffMin = value - this.getMin();
            double range = Math.abs(this.getMax() - this.getMin());
            double relPos = diffMin / range;
            return NonLinearTimeAxis.forwardTransform(relPos, this.getThreshold(), this.getWeight()) * this.getWidth();
        }

        public double getThreshold() {
            return this.threshold.get();
        }

        public void setThreshold(double threshold) {
            this.threshold.set(threshold);
        }

        public double getValueForDisplay(double displayPosition) {
            double relPosition = displayPosition / this.getWidth();
            double range = Math.abs(this.getMax() - this.getMin());
            return this.getMin() + NonLinearTimeAxis.backwardTransform(relPosition, this.getThreshold(), this.getWeight()) * range;
        }

        public double getWeight() {
            return this.weight.get();
        }

        public void setWeight(double weight) {
            this.weight.set(weight);
        }

        public DoubleProperty thresholdProperty() {
            return this.threshold;
        }

        public DoubleProperty weightProperty() {
            return this.weight;
        }

        protected List<Double> calculateMajorTickValues(double axisLength, AxisRange axisRange) {
            int nTicks = this.getMaxMajorTickLabelCount();
            ArrayList<Double> tickValues = new ArrayList<Double>(nTicks);
            double nTicksHalf1 = (double)nTicks * this.getThreshold();
            ArrayList<Double> lower = new ArrayList<Double>((int)nTicksHalf1);
            double min = this.getValueForDisplay(0.01 * axisLength);
            lower.add(min);
            tickValues.add(min);
            int i = 1;
            while ((double)i < nTicksHalf1) {
                double axisPos = (double)i / nTicksHalf1 * this.getThreshold() * axisLength;
                double value = this.getValueForDisplay(axisPos);
                tickValues.add(value);
                lower.add(value);
                ++i;
            }
            double nTicksHalf2 = (double)nTicks * (1.0 - this.getThreshold());
            ArrayList<Double> upper = new ArrayList<Double>((int)nTicksHalf2);
            double atThreshold = this.getValueForDisplay(this.getThreshold() * axisLength);
            tickValues.add(atThreshold);
            upper.add(atThreshold);
            lower.add(atThreshold);
            this.lowerFormat.updateFormatter(lower, 1.0);
            int i2 = 1;
            while ((double)i2 < nTicksHalf2 - 2.0) {
                double axisPos = (1.0 + (double)i2 / nTicksHalf2) * this.getThreshold() * axisLength;
                double value = this.getValueForDisplay(axisPos);
                tickValues.add(value);
                upper.add(value);
                ++i2;
            }
            this.upperFormat.updateFormatter(upper, 1.0);
            return tickValues;
        }

        public String getTickMarkLabel(double value) {
            Double boxedValue = value;
            if (this.getDisplayPosition(value) < this.getThreshold() * this.getWidth()) {
                return (this.getWeight() > this.getThreshold() ? this.lowerFormat : this.upperFormat).toString((Number)boxedValue);
            }
            return (this.getWeight() > this.getThreshold() ? this.upperFormat : this.lowerFormat).toString((Number)boxedValue);
        }

        public static double backwardTransform(double x, double threshold, double weight) {
            if (x < threshold) {
                return weight * x / threshold;
            }
            return weight + (1.0 - weight) / (1.0 - threshold) * (x - threshold);
        }

        public static double forwardTransform(double x, double threshold, double weight) {
            if (x < weight) {
                return threshold * x / weight;
            }
            return threshold + (1.0 - threshold) / (1.0 - weight) * (x - weight);
        }
    }
}

