/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.CrosshairIndicator;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInvertedChartSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleInvertedChartSample.class);
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setAutoRanging(false);
        xAxis.setAutoGrowRanging(false);
        xAxis.set(0.0, 100.0);
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setAutoRangePadding(0.5);
        yAxis.setAutoRanging(false);
        yAxis.setAutoGrowRanging(false);
        yAxis.set(-2.0, 2.0);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new CrosshairIndicator(), new EditAxis()});
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1");
        DoubleDataSet dataSet2 = new DoubleDataSet("data set #2");
        dataSet1.addListener(evt -> LOGGER.atInfo().log("dataSet1 - event: " + evt.toString()));
        dataSet2.addListener(evt -> LOGGER.atInfo().log("dataSet2 - event: " + evt.toString()));
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        double[] xValues = new double[100];
        double[] yValues1 = new double[100];
        dataSet2.autoNotification().set(false);
        for (int x = 0; x < 100; ++x) {
            double y1 = Math.cos(Math.toRadians(10.0 * (double)x));
            double y2 = Math.sin(Math.toRadians(10.0 * (double)x));
            xValues[x] = x;
            yValues1[x] = y1;
            dataSet2.add((double)x, y2);
        }
        dataSet1.set(xValues, yValues1);
        dataSet2.autoNotification().set(true);
        dataSet2.invokeListener((UpdateEvent)new UpdatedDataEvent((EventSource)dataSet2, "manual update event"));
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        CheckBox autoX = new CheckBox("auto-range ");
        autoX.selectedProperty().bindBidirectional((Property)xAxis.autoRangingProperty());
        CheckBox autoY = new CheckBox("auto-range ");
        autoY.selectedProperty().bindBidirectional((Property)yAxis.autoRangingProperty());
        CheckBox invertAxisX = new CheckBox("invert ");
        invertAxisX.setSelected(false);
        invertAxisX.selectedProperty().bindBidirectional((Property)xAxis.invertAxisProperty());
        CheckBox invertAxisY = new CheckBox("invert ");
        invertAxisY.setSelected(false);
        invertAxisY.selectedProperty().bindBidirectional((Property)yAxis.invertAxisProperty());
        Scene scene = new Scene((Parent)new VBox(new Node[]{new HBox(new Node[]{new Label("X axis: "), autoX, invertAxisX, new Label(" Y axis: "), autoY, invertAxisY}), chart}), 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

