/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.RollingBufferSample;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.SimplePerformanceMeter;
import de.gsi.dataset.spi.LimitedIndexedTreeDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.time.ZoneOffset;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingBufferSortedTreeSample
extends Application {
    private static final String MONOSPACED = "Monospaced";
    private static final Logger LOGGER = LoggerFactory.getLogger(RollingBufferSortedTreeSample.class);
    public final LimitedIndexedTreeDataSet rollingBufferDipoleCurrent = new LimitedIndexedTreeDataSet("dipole current [A]", RollingBufferSample.BUFFER_CAPACITY);
    public final LimitedIndexedTreeDataSet rollingBufferBeamIntensity = new LimitedIndexedTreeDataSet("beam intensity [ppp]", RollingBufferSample.BUFFER_CAPACITY);
    private final ErrorDataSetRenderer beamIntensityRenderer = new ErrorDataSetRenderer();
    private final ErrorDataSetRenderer dipoleCurrentRenderer = new ErrorDataSetRenderer();
    private Timer timer;

    private void generateData() {
        long startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.rollingBufferDipoleCurrent.getDataCount() == 0) {
            this.rollingBufferBeamIntensity.autoNotification().set(false);
            this.rollingBufferDipoleCurrent.autoNotification().set(false);
            for (int n = RollingBufferSample.N_SAMPLES; n > 0; --n) {
                double t = now - (double)(n * RollingBufferSample.UPDATE_PERIOD) / 1000.0;
                double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
                double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
                double ey = 1.0;
                this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0, new String[0]);
                this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0, new String[0]);
            }
            this.rollingBufferBeamIntensity.autoNotification().set(true);
            this.rollingBufferDipoleCurrent.autoNotification().set(true);
        } else {
            this.rollingBufferDipoleCurrent.autoNotification().set(false);
            double t = now;
            double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
            double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
            double ey = 1.0;
            this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0, new String[0]);
            this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0, new String[0]);
            this.rollingBufferDipoleCurrent.autoNotification().set(true);
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    private HBox getHeaderBar(Scene scene) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTask()));
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.rollingBufferBeamIntensity.reset();
                this.rollingBufferDipoleCurrent.reset();
                this.timer.scheduleAtFixedRate(this.getTask(), 0L, (long)RollingBufferSample.UPDATE_PERIOD);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SimplePerformanceMeter meter = new SimplePerformanceMeter(scene, 500L);
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)MONOSPACED, (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)MONOSPACED, (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)MONOSPACED, (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)MONOSPACED, (double)12.0));
        meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            String fxRate = String.format("%4.1f", meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", meter.getSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s %s", "JavaFX", fxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s %s", "Actual", actualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s %s", "Process-CPU", cpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s %s", "System -CPU", cpuSystem, "%"));
        });
        return new HBox(new Node[]{newDataSet, startTimer, spacer, new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }

    private TimerTask getTask() {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    RollingBufferSortedTreeSample.this.generateData();
                    if (this.updateCount % 20 == 0) {
                        LOGGER.atInfo().log("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
    }

    public BorderPane initComponents(Scene scene) {
        BorderPane root = new BorderPane();
        this.generateData();
        this.initErrorDataSetRenderer(this.beamIntensityRenderer);
        this.initErrorDataSetRenderer(this.dipoleCurrentRenderer);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("time");
        xAxis1.setAutoRangeRounding(false);
        xAxis1.setTickLabelRotation(45.0);
        xAxis1.invertAxis(false);
        xAxis1.setTimeAxis(true);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("beam intensity", "ppp");
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("dipole current", "A");
        yAxis2.setSide(Side.RIGHT);
        yAxis2.setAnimated(false);
        this.dipoleCurrentRenderer.getAxes().add((Object)yAxis2);
        XYChart chart = new XYChart(new Axis[]{xAxis1, yAxis1});
        chart.legendVisibleProperty().set(true);
        chart.setAnimated(false);
        chart.getYAxis().setName(this.rollingBufferBeamIntensity.getName());
        chart.getRenderers().set(0, (Object)this.beamIntensityRenderer);
        chart.getRenderers().add((Object)this.dipoleCurrentRenderer);
        chart.getPlugins().add((Object)new EditAxis());
        this.beamIntensityRenderer.getDatasets().add((Object)this.rollingBufferBeamIntensity);
        this.dipoleCurrentRenderer.getDatasets().add((Object)this.rollingBufferDipoleCurrent);
        if (xAxis1.isTimeAxis() && xAxis1.getAxisLabelFormatter() instanceof DefaultTimeFormatter) {
            DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)xAxis1.getAxisLabelFormatter();
            axisFormatter.setTimeZoneOffset(ZoneOffset.UTC);
            axisFormatter.setTimeZoneOffset(ZoneOffset.ofHoursMinutes(5, 0));
        }
        yAxis1.setForceZeroInRange(true);
        yAxis2.setForceZeroInRange(true);
        yAxis1.setAutoRangeRounding(true);
        yAxis2.setAutoRangeRounding(true);
        root.setTop((Node)this.getHeaderBar(scene));
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        return root;
    }

    protected void initErrorDataSetRenderer(ErrorDataSetRenderer eRenderer) {
        eRenderer.setErrorType(ErrorStyle.ERRORSURFACE);
        eRenderer.setDashSize(0);
        eRenderer.setDrawMarker(false);
        DefaultDataReducer reductionAlgorithm = (DefaultDataReducer)eRenderer.getRendererDataReducer();
        reductionAlgorithm.setMinPointPixelDistance(0);
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1800.0, 400.0);
        root.setCenter((Node)this.initComponents(scene));
        long startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

