/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.CircularDoubleErrorDataSet;
import de.gsi.math.Math;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class PaddedAutoGrowAxisSample
extends Application {
    public void start(Stage primaryStage) throws Exception {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new Zoomer());
        yAxis.setAutoRangePadding(0.05);
        yAxis.setAutoRanging(false);
        yAxis.setAutoGrowRanging(true);
        yAxis.set(0.0, 10.0);
        CircularDoubleErrorDataSet ds = new CircularDoubleErrorDataSet("", 150);
        chart.getDatasets().addAll((Object[])new DataSet[]{ds});
        new Thread(() -> {
            block4: while (true) {
                ds.reset();
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    FXUtils.runAndWait(() -> {
                        yAxis.set(0.0, 10.0);
                        yAxis.getAutoRange().clear();
                    });
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int i = 0;
                while (true) {
                    if (i >= 500) continue block4;
                    ds.add((double)i, 40.0 * Math.sin((double)((double)i * 0.1)) + 100.0 * Math.sin((double)((double)i * 0.02)), 0.0, 0.0);
                    try {
                        TimeUnit.MILLISECONDS.sleep(40L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                break;
            }
        }).start();
        Scene scene = new Scene((Parent)chart, 800.0, 600.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

