/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.EditDataSet;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.XRangeIndicator;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.testdata.spi.GaussFunction;
import de.gsi.dataset.testdata.spi.RandomWalkFunction;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataRendererSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataRendererSample.class);
    private static final int N_SAMPLES1 = 10000;
    private static final int N_SAMPLES2 = 50;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 1000;
    private Timer timer;
    protected int counter1 = -1;
    protected int counter2 = -1;

    public TimerTask getTask(final Renderer renderer1, final Renderer renderer2) {
        return new TimerTask(){
            int updateCount;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    renderer1.getDatasets().setAll((Object[])new DataSet[]{new MetaInfoRandomWalkFunction("random walk", 10000)});
                    renderer2.getDatasets().setAll((Object[])new DataSet[]{new MetaInfoGausFunction("gaussy", 50, 10000)});
                    if (this.updateCount % 100 == 0) {
                        LOGGER.atInfo().log("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("x axis", "samples");
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y axis", "V");
        yAxis1.setAnimated(false);
        yAxis1.setAutoRangePadding(0.1);
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("y axis2", "A");
        yAxis2.setSide(Side.RIGHT);
        yAxis2.setAutoRangePadding(0.1);
        yAxis2.setAnimated(false);
        DefaultNumericAxis yAxis3 = new DefaultNumericAxis("y axis3", "");
        yAxis3.setSide(Side.RIGHT);
        yAxis3.setAnimated(false);
        XYChart chart = new XYChart(new Axis[]{xAxis1, yAxis1});
        chart.setAnimated(false);
        ErrorDataSetRenderer renderer1 = new ErrorDataSetRenderer();
        ErrorDataSetRenderer renderer2 = new ErrorDataSetRenderer();
        renderer2.getAxes().add((Object)yAxis2);
        MetaDataRenderer metaDataRenderer = new MetaDataRenderer((Chart)chart);
        chart.getRenderers().setAll((Object[])new Renderer[]{renderer1, renderer2});
        chart.getRenderers().add((Object)metaDataRenderer);
        this.getTask((Renderer)renderer1, (Renderer)renderer2).run();
        chart.getPlugins().add((Object)new ParameterMeasurements());
        Zoomer zoom = new Zoomer();
        chart.getPlugins().add((Object)zoom);
        XRangeIndicator xRange = new XRangeIndicator((Axis)xAxis1, 50.0, 60.0);
        chart.getPlugins().add((Object)xRange);
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new TableViewer());
        chart.getPlugins().add((Object)new EditDataSet());
        chart.getPlugins().add((Object)new DataPointTooltip());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getAllDatasets().addListener(c -> {
            while (c.next()) {
                if (c.getAddedSize() > 0) {
                    metaDataRenderer.getDatasets().addAll((Collection)c.getAddedSubList());
                }
                if (c.getRemovedSize() <= 0) continue;
                metaDataRenderer.getDatasets().removeAll((Collection)c.getRemoved());
            }
        });
        metaDataRenderer.getDatasets().addAll((Collection)chart.getAllDatasets());
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> this.getTask((Renderer)renderer1, (Renderer)renderer2).run());
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer("sample-update-timer", true);
                this.timer.scheduleAtFixedRate(this.getTask((Renderer)renderer1, (Renderer)renderer2), 1000L, 1000L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        ComboBox dataSideSelector = new ComboBox();
        dataSideSelector.getItems().addAll((Object[])Side.values());
        dataSideSelector.valueProperty().bindBidirectional((Property)metaDataRenderer.infoBoxSideProperty());
        CheckBox drawOnTopOfCanvas = new CheckBox("Draw on Canvas?");
        drawOnTopOfCanvas.selectedProperty().bindBidirectional((Property)metaDataRenderer.drawOnCanvasProperty());
        root.setTop((Node)new HBox(new Node[]{newDataSet, startTimer, new Label("Meta-Data Info side: "), dataSideSelector, drawOnTopOfCanvas}));
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    class MetaInfoRandomWalkFunction
    extends RandomWalkFunction
    implements DataSetMetaData {
        private static final long serialVersionUID = -7647999890793017350L;

        public MetaInfoRandomWalkFunction(String name, int count) {
            super(name, count);
            ++MetaDataRendererSample.this.counter1;
        }

        public List<String> getErrorList() {
            if (MetaDataRendererSample.this.counter1 % 3 == 0) {
                return Arrays.asList("over-range", "under-range");
            }
            return Collections.emptyList();
        }

        public List<String> getInfoList() {
            if (MetaDataRendererSample.this.counter1 % 2 == 0) {
                return Arrays.asList("info1", "info2");
            }
            return Collections.emptyList();
        }

        public List<String> getWarningList() {
            if (MetaDataRendererSample.this.counter1 % 2 == 0) {
                return Collections.singletonList("gain-range");
            }
            return Collections.emptyList();
        }
    }

    class MetaInfoGausFunction
    extends GaussFunction
    implements DataSetMetaData {
        private static final long serialVersionUID = -397052291718132117L;
        private final int range;

        public MetaInfoGausFunction(String name, int count, int range2) {
            super(name, count);
            ++MetaDataRendererSample.this.counter2;
            this.range = range2;
            this.setStyle("fillColor=green");
        }

        public double get(int dimIndex, int index) {
            if (dimIndex == 0) {
                return (double)index / (double)this.getDataCount() * (double)this.range;
            }
            double x = this.get(0, index);
            return 1000.0 * MetaInfoGausFunction.gauss((double)x, (double)(0.5 * (double)this.range), (double)1000.0);
        }

        public List<String> getErrorList() {
            if (MetaDataRendererSample.this.counter2 % 2 == 0) {
                return Collections.singletonList("over-range");
            }
            return Collections.emptyList();
        }

        public List<String> getInfoList() {
            if (MetaDataRendererSample.this.counter1 % 4 == 0) {
                return Collections.singletonList("info1");
            }
            return Collections.emptyList();
        }

        public List<String> getWarningList() {
            if (MetaDataRendererSample.this.counter1 % 2 == 0) {
                return Collections.singletonList("gain-range");
            }
            return Collections.emptyList();
        }
    }
}

