/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class LogAxisSample
extends Application {
    private static final int N_SAMPLES = 1000;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setLogAxis(true);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        Zoomer zoomer = new Zoomer();
        zoomer.setPannerEnabled(false);
        chart.getPlugins().add((Object)zoomer);
        chart.getPlugins().add((Object)new EditAxis());
        root.getChildren().add((Object)chart);
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1");
        DoubleDataSet dataSet2 = new DoubleDataSet("data set #2");
        DoubleDataSet dataSet3 = new DoubleDataSet("data set #2");
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2, dataSet3});
        dataSet1.autoNotification().set(false);
        dataSet2.autoNotification().set(false);
        dataSet3.autoNotification().set(false);
        for (int n = 0; n < 1000; ++n) {
            double x = (double)n + 1.0;
            double y = 0.01 * (double)(n + 1);
            dataSet1.add(x, 2.0 * x);
            dataSet2.add(x, Math.pow(2.0, y));
            dataSet3.add(x, Math.exp(y));
        }
        dataSet1.autoNotification().set(true);
        dataSet2.autoNotification().set(true);
        dataSet3.autoNotification().set(true);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

