/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import de.gsi.chart.renderer.spi.hexagon.NoPathFoundException;
import java.util.Objects;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexagonSamples
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(HexagonSamples.class);
    private Paint oldHexColour;

    public void start(Stage primaryStage) throws Exception {
        Image image = new Image(Objects.requireNonNull(HexagonSamples.class.getResourceAsStream("./testdata/EU.png")));
        HexagonMap map = new HexagonMap(6, image, 80, (q, r, imagePixelColor, map1) -> {
            if (imagePixelColor.getBlue() > 0.6) {
                Hexagon h = new Hexagon(q, r);
                if (imagePixelColor.getRed() < 0.1) {
                    h.setFill((Paint)Color.DARKBLUE);
                    h.setStroke((Paint)Color.WHITE);
                    h.setIsBlockingPath(false);
                } else {
                    h.setFill((Paint)Color.LIGHTGRAY);
                    h.setStroke((Paint)Color.GRAY);
                    h.setIsBlockingPath(true);
                }
                h.setStrokeWidth(0.5);
                map1.addHexagon(h);
            }
        });
        Hexagon start = map.getHexagon(18, 54);
        Hexagon destination = map.getHexagon(4, 57);
        try {
            for (Hexagon hexagon2 : start.getPathTo(destination)) {
                hexagon2.setFill((Paint)Color.RED);
            }
        }
        catch (NoPathFoundException e) {
            LOGGER.atInfo().log("could not find path for given start/destination coordinates" + e);
        }
        map.setOnHexagonClickedCallback(hexagon -> {
            hexagon.setBackgroundColor(Color.BLUE);
            LOGGER.atInfo().log("clicked on " + hexagon);
        });
        map.setOnHexagonEnteredCallback(hexagon -> {
            this.oldHexColour = hexagon.getFill();
            hexagon.setFill((Paint)Color.YELLOW.darker());
        });
        map.setOnHexagonExitCallback(hexagon -> {
            if (this.oldHexColour != null) {
                hexagon.setFill(this.oldHexColour);
            }
        });
        Group hexagonGroup = new Group();
        map.setRenderCoordinates(false);
        map.render(hexagonGroup);
        Canvas canvas = new Canvas();
        canvas.setWidth(850.0);
        canvas.setHeight(700.0);
        map.render(canvas);
        map.registerCanvasMouseLiner(canvas);
        Scene hexScene = new Scene((Parent)new HBox(new Node[]{hexagonGroup, canvas}), 1700.0, 700.0);
        primaryStage.setTitle(HexagonSamples.class.getSimpleName());
        primaryStage.setScene(hexScene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

