/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.CrosshairIndicator;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.testdata.spi.CosineFunction;
import de.gsi.dataset.testdata.spi.GaussFunction;
import de.gsi.dataset.testdata.spi.RandomWalkFunction;
import java.util.Objects;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssStylingSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssStylingSample.class);
    private static final int N_SAMPLES = 100;
    public static final ObservableList<String> CSS_LIST = FXCollections.observableArrayList((Object[])new String[]{"none", "CustomCss1.css", "CustomCss2.css"});

    public void start(Stage primaryStage) {
        ComboBox globalCssBox = new ComboBox(CSS_LIST);
        globalCssBox.getSelectionModel().select(0);
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setAutoRanging(true);
        yAxis.setAutoRangePadding(0.5);
        XYChart chart = new XYChart(new Axis[]{new DefaultNumericAxis(), yAxis});
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new CrosshairIndicator(), new EditAxis()});
        chart.getDatasets().addAll((Object[])new DataSet[]{new GaussFunction("Gauss", 100), new CosineFunction("Cosine", 100)});
        ComboBox cssBox = new ComboBox(CSS_LIST);
        cssBox.getSelectionModel().select(0);
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        DefaultNumericAxis yAxisRight = new DefaultNumericAxis();
        yAxisRight.setAutoRanging(true);
        yAxisRight.setAutoRangePadding(0.5);
        XYChart chartRight = new XYChart(new Axis[]{new DefaultNumericAxis(), yAxisRight});
        chartRight.getPlugins().addAll((Object[])new ChartPlugin[]{new Zoomer(), new DataPointTooltip(), new EditAxis()});
        chartRight.getDatasets().addAll((Object[])new DataSet[]{new RandomWalkFunction("RandomWalk", 100)});
        ComboBox cssBoxRight = new ComboBox(CSS_LIST);
        cssBoxRight.getSelectionModel().select(0);
        VBox.setVgrow((Node)chartRight, (Priority)Priority.ALWAYS);
        HBox hBox = new HBox(new Node[]{new VBox(new Node[]{new HBox(new Node[]{new Label("Stylesheet for left HBox: "), cssBox}), chart}), new VBox(new Node[]{new HBox(new Node[]{new Label("Stylesheet for right HBox: "), cssBoxRight}), chartRight})});
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.getChildren().forEach(child -> HBox.setHgrow((Node)child, (Priority)Priority.ALWAYS));
        Scene scene = new Scene((Parent)new VBox(new Node[]{new HBox(new Node[]{new Label("Stylesheet for Scene: "), globalCssBox}), hBox}), 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        globalCssBox.valueProperty().addListener((prop, oldVal, newVal) -> {
            if ("none".equals(newVal)) {
                scene.getStylesheets().clear();
            } else {
                scene.getStylesheets().setAll((Object[])new String[]{Objects.requireNonNull(CssStylingSample.class.getResource((String)newVal), "could not load css file: " + newVal).toExternalForm()});
            }
        });
        cssBox.valueProperty().addListener((prop, oldVal, newVal) -> {
            if ("none".equals(newVal)) {
                chart.getStylesheets().clear();
            } else {
                chart.getStylesheets().setAll((Object[])new String[]{Objects.requireNonNull(CssStylingSample.class.getResource((String)newVal), "could not load css file: " + newVal).toExternalForm()});
            }
        });
        cssBoxRight.valueProperty().addListener((prop, oldVal, newVal) -> {
            if ("none".equals(newVal)) {
                chartRight.getStylesheets().clear();
            } else {
                chartRight.getStylesheets().setAll((Object[])new String[]{Objects.requireNonNull(CssStylingSample.class.getResource((String)newVal), "could not load css file: " + newVal).toExternalForm()});
            }
        });
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

