/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class CategoryAxisSample
extends Application {
    private static final int N_SAMPLES = 30;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        CategoryAxis xAxis = new CategoryAxis("months");
        xAxis.setOverlapPolicy(AxisLabelOverlapPolicy.SHIFT_ALT);
        xAxis.setMaxMajorTickLabelCount(31);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("yAxis");
        XYChart lineChartPlot = new XYChart(new Axis[]{xAxis, yAxis});
        lineChartPlot.setAnimated(false);
        lineChartPlot.getRenderers().clear();
        ErrorDataSetRenderer renderer = new ErrorDataSetRenderer();
        renderer.setPolyLineStyle(LineStyle.NORMAL);
        renderer.setPolyLineStyle(LineStyle.HISTOGRAM);
        lineChartPlot.getRenderers().add((Object)renderer);
        lineChartPlot.legendVisibleProperty().set(true);
        lineChartPlot.getPlugins().add((Object)new ParameterMeasurements());
        lineChartPlot.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        lineChartPlot.getPlugins().add((Object)zoomer);
        DefaultErrorDataSet dataSet = new DefaultErrorDataSet("myData");
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.ENGLISH);
        ArrayList<String> categories = new ArrayList<String>(Arrays.asList(Arrays.copyOf(dfs.getShortMonths(), 12)));
        for (int i = categories.size(); i < 30; ++i) {
            categories.add("Month" + (i + 1));
        }
        xAxis.setCategories(categories);
        double y = 0.0;
        for (int n = 0; n < 30; ++n) {
            double ex = 0.0;
            double ey = 0.1;
            dataSet.add((double)n, y += RandomDataGenerator.random() - 0.5, 0.0, 0.1);
            dataSet.addDataLabel(n, "SpecialCategory#" + n);
        }
        lineChartPlot.getDatasets().add((Object)dataSet);
        root.getChildren().add((Object)lineChartPlot);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

