/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote;

import de.gsi.acc.remote.clipboard.Clipboard;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.OscilloscopeAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Screenshot;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.samples.RollingBufferSample;
import de.gsi.chart.ui.ProfilerInfoBox;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.LimitedIndexedTreeDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZoneOffset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipboardSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipboardSample.class);
    private static final boolean isRunningHeadless = System.getProperty("monocle.platform") != null;
    private static final int DEBUG_UPDATE_RATE = 2000;
    private static final int N_SAMPLES = 750;
    private static final int UPDATE_PERIOD = 40;
    private Clipboard remoteView;
    private XYChart chart;
    private final LimitedIndexedTreeDataSet currentDataSet = new LimitedIndexedTreeDataSet("dipole current [A]", 750);
    private final LimitedIndexedTreeDataSet intensityDataSet = new LimitedIndexedTreeDataSet("beam intensity [ppp]", 750);
    private Timer timer;
    private final Runnable startStopTimerAction = () -> {
        if (this.timer == null) {
            this.timer = new Timer("sample-update-timer", true);
            this.intensityDataSet.reset();
            this.currentDataSet.reset();
            this.timer.scheduleAtFixedRate(this.getTask(), 0L, 40L);
        } else {
            this.timer.cancel();
            this.timer = null;
        }
    };

    private BorderPane initComponents(Scene scene) {
        ErrorDataSetRenderer beamIntensityRenderer = new ErrorDataSetRenderer();
        this.initErrorDataSetRenderer(beamIntensityRenderer);
        ErrorDataSetRenderer dipoleCurrentRenderer = new ErrorDataSetRenderer();
        this.initErrorDataSetRenderer(dipoleCurrentRenderer);
        DefaultNumericAxis xAxis = new DefaultNumericAxis("time");
        xAxis.setAutoRangeRounding(false);
        xAxis.setAutoRangePadding(0.001);
        xAxis.setTimeAxis(true);
        OscilloscopeAxis yAxis1 = new OscilloscopeAxis("beam intensity", "ppp");
        OscilloscopeAxis yAxis2 = new OscilloscopeAxis("dipole current", "A");
        yAxis2.setSide(Side.RIGHT);
        yAxis1.setAxisZeroPosition(0.05);
        yAxis2.setAxisZeroPosition(0.05);
        yAxis1.setAutoRangeRounding(true);
        yAxis2.setAutoRangeRounding(true);
        dipoleCurrentRenderer.getAxes().add((Object)yAxis2);
        this.chart = new XYChart(new Axis[]{xAxis, yAxis1});
        this.chart.getPlugins().add((Object)new ParameterMeasurements());
        this.chart.getPlugins().add((Object)new Screenshot());
        this.chart.getPlugins().add((Object)new EditAxis());
        this.chart.legendVisibleProperty().set(true);
        this.chart.setAnimated(false);
        this.chart.getYAxis().setName(this.intensityDataSet.getName());
        this.chart.getRenderers().set(0, (Object)beamIntensityRenderer);
        this.chart.getRenderers().add((Object)dipoleCurrentRenderer);
        this.chart.getPlugins().add((Object)new EditAxis());
        beamIntensityRenderer.getDatasets().add((Object)this.intensityDataSet);
        dipoleCurrentRenderer.getDatasets().add((Object)this.currentDataSet);
        if (xAxis.isTimeAxis() && xAxis.getAxisLabelFormatter() instanceof DefaultTimeFormatter) {
            DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)xAxis.getAxisLabelFormatter();
            axisFormatter.setTimeZoneOffset(ZoneOffset.UTC);
            axisFormatter.setTimeZoneOffset(ZoneOffset.ofHoursMinutes(2, 0));
        }
        BorderPane root = new BorderPane((Node)this.chart);
        root.setTop((Node)this.getHeaderBar(scene));
        return root;
    }

    public void start(Stage primaryStage) {
        LOGGER.atInfo().addArgument((Object)isRunningHeadless).log("sample runs in headless mode = {}");
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        Scene scene = new Scene((Parent)new BorderPane(), 1800.0, 400.0);
        BorderPane root = this.initComponents(scene);
        scene.setRoot((Parent)root);
        long startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        if (!isRunningHeadless) {
            primaryStage.setScene(scene);
            primaryStage.setOnCloseRequest(evt -> System.exit(0));
            primaryStage.show();
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
        System.setProperty("restServerPort", "8080");
        System.setProperty("restServerPort2", "8443");
        this.remoteView = new Clipboard("/", "status", (Region)root, 40L, TimeUnit.MILLISECONDS, true);
        if (!isRunningHeadless) {
            this.chart.addListener(obs -> this.remoteView.handle(new UpdateEvent((EventSource)this.remoteView, "regular clipboard update")));
        } else {
            new Timer("headless-update-timer", true).scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ClipboardSample.this.remoteView.handle(new UpdateEvent((EventSource)ClipboardSample.this.remoteView, "headless clipboard update"));
                }
            }, 0L, 40L);
        }
        Label userCount = new Label();
        this.remoteView.userCountProperty().addListener((obs, o, n) -> userCount.setText("GET Clients = " + n.toString() + " "));
        Label userSseCount = new Label();
        this.remoteView.userCountSseProperty().addListener((obs, o, n) -> userSseCount.setText("SSE Listeners = " + n.toString() + " "));
        this.remoteView.addTestImageData();
        root.setBottom((Node)new HBox(new Node[]{userCount, userSseCount}));
        root.getBottom().setStyle("-fx-background-color: transparent;");
        this.startStopTimerAction.run();
    }

    private void initErrorDataSetRenderer(ErrorDataSetRenderer eRenderer) {
        eRenderer.setErrorType(ErrorStyle.ERRORSURFACE);
        eRenderer.setDashSize(1);
        eRenderer.setDrawMarker(false);
        DefaultDataReducer reductionAlgorithm = (DefaultDataReducer)eRenderer.getRendererDataReducer();
        reductionAlgorithm.setMinPointPixelDistance(1);
    }

    private void generateData() {
        long startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.currentDataSet.getDataCount() == 0) {
            this.intensityDataSet.autoNotification().set(false);
            this.currentDataSet.autoNotification().set(false);
            for (int n = RollingBufferSample.N_SAMPLES; n > 0; --n) {
                double t = now - (double)(n * RollingBufferSample.UPDATE_PERIOD) / 1000.0;
                double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
                double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
                double ey = 1.0;
                this.currentDataSet.add(t, y, 1.0, 1.0, new String[0]);
                this.intensityDataSet.add(t, y2, 1.0, 1.0, new String[0]);
            }
            this.intensityDataSet.autoNotification().set(true);
            this.currentDataSet.autoNotification().set(true);
        } else {
            this.currentDataSet.autoNotification().set(false);
            double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(now);
            double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(now);
            double ey = 1.0;
            this.currentDataSet.add(now, y, 1.0, 1.0, new String[0]);
            this.intensityDataSet.add(now, y2, 1.0, 1.0, new String[0]);
            this.currentDataSet.autoNotification().set(true);
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    private HBox getHeaderBar(Scene scene) {
        Button localCopy = new Button("local copy");
        localCopy.setTooltip(new Tooltip("press to open browser pointing to local URL"));
        localCopy.setOnAction(evt -> ClipboardSample.openWebpage(this.remoteView.getLocalURI()));
        Button publicCopy = new Button("public copy");
        publicCopy.setTooltip(new Tooltip("press to open browser pointing to public URL"));
        publicCopy.setOnAction(evt -> ClipboardSample.openWebpage(this.remoteView.getPublicURI()));
        Button startTimer = new Button("stop timer");
        publicCopy.setTooltip(new Tooltip("press to start/stop timer updates"));
        startTimer.setOnAction(evt -> {
            this.startStopTimerAction.run();
            FXUtils.runFX(() -> {
                if (startTimer.getText().startsWith("stop")) {
                    startTimer.setText("start timer");
                } else {
                    startTimer.setText("stop timer");
                }
            });
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return new HBox(new Node[]{localCopy, publicCopy, startTimer, spacer, new ProfilerInfoBox(scene, 2000).setDebugLevel(ProfilerInfoBox.DebugLevel.FRAMES_PER_SECOND)});
    }

    private TimerTask getTask() {
        return new TimerTask(){
            private int updateCount;

            @Override
            public void run() {
                ClipboardSample.this.generateData();
                if (this.updateCount % 10000 == 0) {
                    LOGGER.atInfo().log("update iteration #" + this.updateCount);
                }
                ++this.updateCount;
            }
        };
    }

    public static void openWebpage(URI uri) {
        new Thread(() -> {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(uri);
                }
                catch (Exception e) {
                    LOGGER.atError().setCause((Throwable)e).log("openWebpage(URI)");
                }
            }
        }).start();
    }

    public static void openWebpage(URL url) {
        try {
            ClipboardSample.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.atError().setCause((Throwable)e).log("openWebpage(URL)");
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

