/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.misc.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.ProfilerInfoBox;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.TransposedDataSet;
import de.gsi.misc.samples.plugins.Snow;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlakeSample
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowFlakeSample.class);
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    protected static final String FONT_SYMBOL_TRANSPOSE = "fas-sync:20";
    protected static final String FONT_SYMBOL_SNOW = "fa-snowflake-o:20";
    private static final int WIDTH = 1200;
    private static final int HEIGHT = 600;
    private final List<DataSet> tree = SnowFlakeSample.christmasTree();
    private final DataSet ornaments = SnowFlakeSample.treeOrnaments(this.tree.get(1), 0.5);
    private final BooleanProperty flipProperty = new SimpleBooleanProperty((Object)this, "flip", false);
    private final BooleanProperty snowProperty = new SimpleBooleanProperty((Object)this, "snowProperty", true);
    private final IntegerProperty numberOfFlakesProperty = new SimpleIntegerProperty((Object)this, "numberOfFlakes", 100);
    private final DoubleProperty velocityProperty = new SimpleDoubleProperty((Object)this, "velocity", 0.1);
    private final DoubleProperty meanSizeProperty = new SimpleDoubleProperty((Object)this, "meanSizeProperty", 10.0);
    private final DoubleProperty rmsSizeProperty = new SimpleDoubleProperty((Object)this, "rmsSizeProperty", 5.0);

    public void start(Stage primaryStage) {
        XYChart chart1 = this.getChristmasChart(false);
        XYChart chart2 = this.getChristmasChart(true);
        CheckBox cbTransposed = new CheckBox("flip tree");
        cbTransposed.setTooltip(new Tooltip("press to flip tree"));
        cbTransposed.setGraphic((Node)new FontIcon(FONT_SYMBOL_TRANSPOSE));
        cbTransposed.selectedProperty().bindBidirectional((Property)this.flipProperty);
        CheckBox cbSnow = new CheckBox("snow");
        cbSnow.setTooltip(new Tooltip("press to switch on/off snow"));
        cbSnow.setGraphic((Node)new FontIcon(FONT_SYMBOL_SNOW));
        cbSnow.selectedProperty().bindBidirectional((Property)this.snowProperty);
        Slider nFlakeSpeed = new Slider(0.0, 2.0, this.velocityProperty.get());
        nFlakeSpeed.setMaxWidth(100.0);
        nFlakeSpeed.setBlockIncrement(0.1);
        nFlakeSpeed.setMajorTickUnit(0.1);
        this.velocityProperty.bind((ObservableValue)nFlakeSpeed.valueProperty());
        Spinner nSnowFlakes = new Spinner(10, 1000, 200, this.numberOfFlakesProperty.get());
        nSnowFlakes.setMaxWidth(75.0);
        this.numberOfFlakesProperty.bind((ObservableValue)nSnowFlakes.valueProperty());
        Spinner meanFlakeSize = new Spinner(0.1, 20.0, this.meanSizeProperty.get(), 0.1);
        meanFlakeSize.setMaxWidth(75.0);
        this.meanSizeProperty.bind((ObservableValue)meanFlakeSize.valueProperty());
        Spinner rmsFlakeSize = new Spinner(0.1, 20.0, this.rmsSizeProperty.get(), 0.1);
        rmsFlakeSize.setMaxWidth(75.0);
        this.rmsSizeProperty.bind((ObservableValue)rmsFlakeSize.valueProperty());
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        ProfilerInfoBox profilerInfoBox = new ProfilerInfoBox();
        profilerInfoBox.setDebugLevel(ProfilerInfoBox.DebugLevel.NONE);
        ToolBar toolBar = new ToolBar(new Node[]{cbTransposed, cbSnow, new Label("speed:"), nFlakeSpeed, new Label("n-flakes:"), nSnowFlakes, new Label("mean-size:"), meanFlakeSize, new Label("rms-size:"), rmsFlakeSize, spacer, profilerInfoBox});
        HBox hBox = new HBox(new Node[]{chart1, chart2});
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        Scene scene = new Scene((Parent)new VBox(new Node[]{toolBar, hBox}), 1200.0, 600.0);
        primaryStage.setTitle(SnowFlakeSample.class.getSimpleName());
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.setScene(scene);
        primaryStage.show();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("scene initialised");
        }
    }

    private XYChart getChristmasChart(boolean inverted) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis("X", "mas");
        xAxis.setAutoRanging(false);
        xAxis.set(-11.0, 11.0);
        xAxis.setSide(Side.CENTER_HOR);
        xAxis.getAxisLabel().setTextAlignment(TextAlignment.RIGHT);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("Y", "mas");
        yAxis.setAutoRanging(false);
        yAxis.set(-11.0, 11.0);
        yAxis.getAxisLabel().setTextAlignment(TextAlignment.RIGHT);
        yAxis.setSide(Side.CENTER_VER);
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        Snow snowPlugin = new Snow();
        snowPlugin.snowProperty().bind((ObservableValue)this.snowProperty);
        snowPlugin.velocityProperty().bind((ObservableValue)this.velocityProperty);
        snowPlugin.numberOfFlakesProperty().bind((ObservableValue)this.numberOfFlakesProperty);
        snowPlugin.meanSizeProperty().bind((ObservableValue)this.meanSizeProperty);
        snowPlugin.rmsSizeProperty().bind((ObservableValue)this.rmsSizeProperty);
        chart.getPlugins().add((Object)snowPlugin);
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        chart.getGridRenderer().setDrawOnTop(false);
        chart.setLegendVisible(false);
        chart.setTitle((inverted ? "Y" : "X") + "-mas tree");
        this.flipProperty.addListener((ch, o, n) -> chart.setTitle((inverted ^ n ? "Y" : "X") + "-mas tree"));
        ErrorDataSetRenderer renderer1 = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        renderer1.setAssumeSortedData(false);
        renderer1.setPolyLineStyle(LineStyle.AREA);
        renderer1.setPointReduction(false);
        ErrorDataSetRenderer renderer2 = new ErrorDataSetRenderer();
        renderer2.setPolyLineStyle(LineStyle.NONE);
        renderer2.setDrawMarker(true);
        chart.getRenderers().add((Object)renderer2);
        TransposedDataSet transposeStump = TransposedDataSet.transpose((DataSet)this.tree.get(0), (boolean)inverted);
        TransposedDataSet transposeTree = TransposedDataSet.transpose((DataSet)this.tree.get(1), (boolean)inverted);
        TransposedDataSet transposeOrnaments = TransposedDataSet.transpose((DataSet)this.ornaments, (boolean)inverted);
        renderer1.getDatasets().addAll((Object[])new DataSet[]{transposeStump, transposeTree});
        renderer2.getDatasets().add((Object)transposeOrnaments);
        this.flipProperty.addListener((ch, o, n) -> {
            transposeStump.setTransposed(inverted ^ n);
            transposeTree.setTransposed(inverted ^ n);
            transposeOrnaments.setTransposed(inverted ^ n);
        });
        return chart;
    }

    public static List<DataSet> christmasTree() {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        double scale = 2.5;
        double[] xStomp = new double[]{0.0, 2.0, 2.0, 0.0};
        double[] yStomp = new double[]{2.0, 2.0, -2.0, -2.0};
        int i = 0;
        while (i < xStomp.length) {
            int n = i;
            xStomp[n] = xStomp[n] / 2.5;
            int n2 = i++;
            yStomp[n2] = yStomp[n2] / 2.5;
        }
        DataSet stomp = new DataSetBuilder().setName("tree").setValues(0, xStomp).setValues(1, yStomp).build();
        stomp.getAxisDescription(0).set("X", new String[]{"Mas"});
        stomp.getAxisDescription(1).set("Y", new String[]{"Mas"});
        stomp.setStyle("strokeColor=#B5651D; fillColor=#B5651D");
        double[] xTree = new double[]{2.0, 2.0, 8.0, 8.0, 12.0, 12.0, 16.0, 16.0, 21.0, 16.0, 16.0, 12.0, 12.0, 8.0, 8.0, 2.0, 2.0};
        double[] yTree = new double[]{0.0, 9.0, 4.0, 7.0, 3.0, 5.0, 2.0, 3.0, 0.0, -3.0, -2.0, -5.0, -3.0, -7.0, -4.0, -9.0, 0.0};
        int i2 = 0;
        while (i2 < xTree.length) {
            int n = i2;
            xTree[n] = xTree[n] / 2.5;
            int n3 = i2++;
            yTree[n3] = yTree[n3] / 2.5;
        }
        DataSet tree = new DataSetBuilder().setName("tree").setValues(0, xTree).setValues(1, yTree).build();
        tree.getAxisDescription(0).set("X", new String[]{"Mas"});
        tree.getAxisDescription(1).set("Y", new String[]{"Max"});
        tree.setStyle("strokeColor=darkGreen; fillColor=green");
        list.add(stomp);
        list.add(tree);
        return list;
    }

    public static void main(String[] args) {
        SnowFlakeSample.launch((String[])args);
    }

    public static DataSet treeOrnaments(DataSet tree, double spacing) {
        DoubleDataSet dataSet = new DoubleDataSet("ornaments");
        dataSet.setStyle("markerType=circle;");
        tree.recomputeLimits(0);
        tree.recomputeLimits(1);
        double xMin = ((AxisDescription)tree.getAxisDescriptions().get(0)).getMin();
        double xMax = ((AxisDescription)tree.getAxisDescriptions().get(0)).getMax();
        double yMin = ((AxisDescription)tree.getAxisDescriptions().get(1)).getMin();
        double yMax = ((AxisDescription)tree.getAxisDescriptions().get(1)).getMax();
        int count = 0;
        int count2 = 0;
        for (double x = xMin; x <= xMax; x += spacing) {
            for (double y = yMin; y <= yMax; y += spacing) {
                double yTree = Math.abs(tree.getValue(1, new double[]{x}));
                String markerSize = "markerSize=3; index=" + count + ";";
                if (!(Math.abs(y) <= yTree - 0.5 * spacing) || !(Math.random() < 0.7)) continue;
                String ballStyle = count2 % 2 == 0 ? "markerColor=#FF0000;" : "markerColor=orange;";
                dataSet.add(x, y);
                dataSet.addDataStyle(count, markerSize + ballStyle);
                ++count;
                ++count2;
            }
            ++count2;
        }
        return dataSet;
    }
}

