/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.ArrayMath;
import de.gsi.math.Math;
import de.gsi.math.functions.RandomWalkFunction;
import de.gsi.math.samples.WaveletScalogram;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.wavelet.CDFWavelet;
import de.gsi.math.spectra.wavelet.FastWaveletTransform;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Random;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveletDenoising
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaveletDenoising.class);
    private static final int MAX_POINTS = 512;
    private static final boolean LOAD_EXAMPLE_DATA = false;
    private DataSet fraw;
    private DataSet fdata;
    private DataSet freconstructed;
    private DataSet fspectraModel;
    private DataSet fspectra;
    private DataSet fspectraFit;

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setName("time");
        chart1.getDatasets().addAll((Object[])new DataSet[]{this.fdata, this.fraw, this.freconstructed});
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setName("frequency");
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fspectraModel, this.fspectra, this.fspectraFit});
        return new VBox(new Node[]{chart1, chart2});
    }

    private void initData() {
        double error2;
        RandomWalkFunction func = new RandomWalkFunction("rand1", 0.1);
        double[] xValues = new double[512];
        double[] yValues = new double[512];
        double[] yModel = new double[512];
        Random rnd = new Random();
        for (int i = 0; i < xValues.length; ++i) {
            double x = i;
            double offset = 0.0;
            double error = 0.2 * rnd.nextGaussian();
            if (i > xValues.length / 2) {
                offset = -0.05;
            }
            xValues[i] = x;
            yValues[i] = func.getValue(0.0);
            yModel[i] = Math.sin((double)(0.0018849555921538756 * x * (x + offset)));
            yModel[i] = Math.sin((double)(0.3141592653589793 * x));
            if (i < 100 || i > 400) {
                yModel[i] = 0.0;
            }
            yValues[i] = yModel[i] + 0.0 * error;
        }
        CDFWavelet wvTrafo1 = new CDFWavelet();
        boolean trafo1 = false;
        double[] ySmooth = Arrays.copyOf(yValues, yValues.length);
        double[] ySModel = Arrays.copyOf(yModel, yModel.length);
        FastWaveletTransform.transform((double[])ySmooth);
        FastWaveletTransform.transform((double[])ySModel);
        double[] recon = Arrays.copyOf(ySmooth, yValues.length);
        double[] reconAbs = Arrays.copyOf(ySmooth, yValues.length);
        for (int i = 0; i < reconAbs.length; ++i) {
            reconAbs[i] = Math.abs((double)recon[i]);
        }
        Arrays.fill(recon, 0.0);
        this.fspectraModel = new DefaultDataSet("model", xValues, ySModel, xValues.length, true);
        this.fspectra = new DefaultDataSet("raw data", xValues, ySmooth, xValues.length, true);
        this.fspectraFit = new DefaultDataSet("reconstructed", xValues, Arrays.copyOf(recon, recon.length), xValues.length, true);
        FastWaveletTransform.invTransform((double[])recon);
        double[] diff1 = ArrayMath.subtract((double[])yValues, (double[])yModel);
        double error1 = diff1 == null ? 0.0 : Math.rms((double[])diff1);
        double[] diff2 = ArrayMath.subtract((double[])recon, (double[])yModel);
        double d = error2 = diff2 == null ? 0.0 : Math.rms((double[])diff2);
        if (error1 > error2 && error1 != 0.0) {
            LOGGER.atInfo().addArgument((Object)error1).addArgument((Object)error2).addArgument((Object)((error1 - error2) / error1 * 100.0)).log("improved noise floor from {} \t-> {} \t({}%)");
        } else if (error1 != 0.0) {
            LOGGER.atInfo().addArgument((Object)error1).addArgument((Object)error2).addArgument((Object)((error1 - error2) / error1 * 100.0)).log("deteriorated noise floor from {} \t-> {} \\t({}%)");
        } else {
            LOGGER.atInfo().addArgument((Object)error1).addArgument((Object)error2).log("changed noise floor from {} \\t-> {}");
        }
        this.fdata = new DefaultDataSet("model ", xValues, yModel, xValues.length, true);
        this.fraw = new DefaultDataSet("raw data", xValues, yValues, xValues.length, true);
        this.freconstructed = new DefaultDataSet("reconstructed", xValues, recon, xValues.length, true);
    }

    private static double[][] readDemoData() {
        double[][] dArray;
        String fileName = "./BBQSpectra.dat";
        BufferedReader reader = new BufferedReader(new InputStreamReader(WaveletScalogram.class.getResourceAsStream("./BBQSpectra.dat")));
        try {
            String line = reader.readLine();
            int nDim = line == null ? 0 : Integer.parseInt(line);
            double[][] ret = new double[2][nDim];
            for (int i = 0; i < nDim && (line = reader.readLine()) != null; ++i) {
                String[] x = line.split("\t");
                ret[0][i] = Double.parseDouble(x[0]);
                ret[1][i] = Double.parseDouble(x[1]);
            }
            dArray = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).log("read error");
                }
                return new double[10][10];
            }
        }
        reader.close();
        return dArray;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

