/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.MathBase;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.SpectrumTools;
import java.util.Arrays;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.jtransforms.fft.DoubleFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexFourierSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexFourierSample.class);
    private static final int MAX_POINTS = 512;
    private static final double T_MAX = 1.0;
    private DataSet frawRe;
    private DataSet frawIm;
    private DataSet fspectra;
    private DataSet fSpectraRe;
    private DataSet fSpectraIm;

    private static double[] computeSignal(double T, int nSamples) {
        double[] val = new double[2 * nSamples];
        int f1 = 30;
        int f2 = 60;
        for (int i = 0; i < nSamples; ++i) {
            int i2 = i << 1;
            double t = (double)i * T / (double)nSamples;
            double a1 = MathBase.sin((double)(188.49555921538757 * t));
            double b1 = MathBase.cos((double)(188.49555921538757 * t));
            double a2 = MathBase.cos((double)(376.99111843077515 * t));
            double b2 = MathBase.sin((double)(376.99111843077515 * t));
            val[i2] = a1 + a2;
            val[i2 + 1] = b1 + b2;
        }
        return val;
    }

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setName("time");
        chart1.getXAxis().setUnit("s");
        chart1.getYAxis().setName("magnitude");
        chart1.getYAxis().setUnit("a.u.");
        chart1.getDatasets().addAll((Object[])new DataSet[]{this.frawRe, this.frawIm});
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setName("frequency [fs]");
        chart2.getXAxis().setUnit("fs");
        chart2.getYAxis().setName("magnitude");
        chart2.getYAxis().setUnit("a.u.");
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fspectra, this.fSpectraRe, this.fSpectraIm});
        return new VBox(new Node[]{chart1, chart2});
    }

    private void initData() {
        double[] xValues = new double[512];
        for (int i = 0; i < xValues.length; ++i) {
            xValues[i] = (double)i * 1.0 / 512.0;
        }
        double[] yValues = ComplexFourierSample.computeSignal(1.0, 512);
        double[] yValuesRe = new double[512];
        double[] yValuesIm = new double[512];
        for (int i = 0; i < 512; ++i) {
            yValuesRe[i] = yValues[i << 1];
            yValuesIm[i] = yValues[(i << 1) + 1];
        }
        this.frawRe = new DefaultDataSet("raw data real", xValues, yValuesRe, xValues.length, true);
        this.frawIm = new DefaultDataSet("raw data imag", xValues, yValuesIm, xValues.length, true);
        double[] frequency1 = new double[512];
        double scaling1 = 1.0 / (double)frequency1.length;
        for (int i = 0; i < frequency1.length; ++i) {
            frequency1[i] = ((double)i - 256.0) * scaling1;
        }
        DoubleFFT_1D fastFourierTrafo = new DoubleFFT_1D(512L);
        double[] fftSpectra = Arrays.copyOf(yValues, yValues.length);
        fastFourierTrafo.complexForward(fftSpectra);
        double[] mag = SpectrumTools.computeMagnitudeSpectrum((double[])fftSpectra, (boolean)true);
        double[] fftSpectraRe = new double[512];
        double[] fftSpectraIm = new double[512];
        for (int i = 0; i < 512; ++i) {
            fftSpectraRe[i] = fftSpectra[i << 1];
            fftSpectraIm[i] = fftSpectra[(i << 1) + 1];
        }
        this.fSpectraRe = new DefaultDataSet("FFT_RE", frequency1, fftSpectraRe, frequency1.length, true);
        this.fSpectraIm = new DefaultDataSet("FFT_IM", frequency1, fftSpectraIm, frequency1.length, true);
        this.fspectra = new DefaultDataSet("FFT", frequency1, mag, frequency1.length, true);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

