/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.plan;

import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.financial.samples.dos.OrderExpression;
import de.gsi.financial.samples.dos.Position;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.CalendarUtils;
import de.gsi.financial.samples.service.OhlcvChangeListener;
import de.gsi.financial.samples.service.StandardTradePlanAttributes;
import de.gsi.financial.samples.service.execution.BasicOrderExecutionService;
import de.gsi.financial.samples.service.execution.ExecutionResult;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MktOrderListTradePlan
implements OhlcvChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MktOrderListTradePlan.class);
    private final BasicOrderExecutionService orderExecutionService;
    private final AttributeModel context;
    private final String asset;
    private final List<SimMktOrder> orders;
    private int orderIdx = 0;
    private boolean nextOrder;
    private Calendar timestamp;
    private int quantity;

    public MktOrderListTradePlan(AttributeModel context, String asset, BasicOrderExecutionService orderExecutionService, List<SimMktOrder> orders) {
        this.context = context;
        this.asset = asset;
        this.orderExecutionService = orderExecutionService;
        this.orders = orders;
        this.nextOrder = !orders.isEmpty();
    }

    @Override
    public void tickEvent(IOhlcvItem ohlcvItem) throws Exception {
        if (this.nextOrder) {
            this.timestamp = CalendarUtils.createByDateTime(this.orders.get((int)this.orderIdx).timestamp);
            this.quantity = this.orders.get((int)this.orderIdx).buySell;
            this.nextOrder = false;
        }
        if (this.timestamp != null && ohlcvItem.getTimeStamp().getTime() >= this.timestamp.getTime().getTime()) {
            ExecutionResult result = this.orderExecutionService.performOrder(ohlcvItem.getTimeStamp(), this.asset, this.quantity > 0 ? OrderExpression.buyMarket(this.quantity) : OrderExpression.sellMarket(Math.abs(this.quantity)));
            LOGGER.info("Last order=" + result.getOrder().toString());
            LOGGER.info(String.format("Positions=%n%s", ((PositionContainer)this.context.getAttribute(StandardTradePlanAttributes.POSITIONS)).getPositionByMarketSymbol(this.asset).stream().map(Position::toString).collect(Collectors.joining(System.lineSeparator()))));
            this.timestamp = null;
            ++this.orderIdx;
            if (this.orderIdx < this.orders.size()) {
                this.nextOrder = true;
            }
        }
    }

    public static class SimMktOrder {
        public String timestamp;
        public int buySell;

        public SimMktOrder(String timestamp, int buySell) {
            this.timestamp = timestamp;
            this.buySell = buySell;
        }
    }
}

