/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.period;

import de.gsi.financial.samples.service.period.Period;

public class IntradayPeriod
extends Period {
    private final IntradayPeriodEnum period;
    private final double periodValue;
    private final Double minimalMoveSymbol;
    private final boolean extendedCalculation;
    private final String calculationAddonServicesType;

    public IntradayPeriod(IntradayPeriodEnum period, double periodValue) {
        super(Period.PeriodType.INTRA);
        this.period = period;
        this.periodValue = periodValue;
        this.minimalMoveSymbol = null;
        this.extendedCalculation = false;
        this.calculationAddonServicesType = null;
    }

    public IntradayPeriod(IntradayPeriodEnum period, double periodValue, Double minimalMoveSymbol, boolean extendedCalculation, String calculationAddonServicesType) {
        super(Period.PeriodType.INTRA);
        this.period = period;
        this.periodValue = periodValue;
        this.minimalMoveSymbol = minimalMoveSymbol;
        this.extendedCalculation = extendedCalculation;
        this.calculationAddonServicesType = calculationAddonServicesType;
    }

    public IntradayPeriodEnum getPeriod() {
        return this.period;
    }

    public double getPeriodValue() {
        return this.periodValue;
    }

    public String getCalculationAddonServicesType() {
        return this.calculationAddonServicesType;
    }

    public Double getMinimalMoveSymbol() {
        return this.minimalMoveSymbol;
    }

    public boolean isExtendedCalculation() {
        return this.extendedCalculation;
    }

    @Override
    public long getMillis() {
        switch (this.period) {
            case S: {
                return 1000L * Math.round(this.periodValue);
            }
            case M: {
                return 60000L * Math.round(this.periodValue);
            }
            case H: {
                return 3600000L * Math.round(this.periodValue);
            }
        }
        return 60000L;
    }

    public String toString() {
        return this.periodValue + this.period.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.period == null ? 0 : this.period.hashCode());
        long temp = Double.doubleToLongBits(this.periodValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntradayPeriod other = (IntradayPeriod)obj;
        if (this.period != other.period) {
            return false;
        }
        return Double.doubleToLongBits(this.periodValue) == Double.doubleToLongBits(other.periodValue);
    }

    public static IntradayPeriod convert(String periodString) {
        if (periodString == null || "".equals(periodString)) {
            return new IntradayPeriod(IntradayPeriodEnum.T, 1.0);
        }
        String periodSymbol = periodString.substring(periodString.length() - 1);
        double periodValue = Double.parseDouble(periodString.substring(0, periodString.length() - 1));
        return new IntradayPeriod(IntradayPeriodEnum.valueOf(periodSymbol), periodValue);
    }

    public static enum IntradayPeriodEnum {
        T,
        S,
        M,
        H,
        RB,
        V;

    }
}

