/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.period;

import de.gsi.financial.samples.service.period.Period;

public class EodPeriod
extends Period {
    public static final EodPeriod DAILY = new EodPeriod();
    private final PeriodEnum period;

    public EodPeriod() {
        this(PeriodEnum.DAILY);
    }

    public EodPeriod(PeriodEnum period) {
        this.period = period;
    }

    public PeriodEnum getPeriod() {
        return this.period;
    }

    @Override
    public long getMillis() {
        switch (this.period) {
            case DAILY: {
                return 86400000L;
            }
            case WEEKLY: {
                return 604800000L;
            }
            case MONTHLY: {
                return 2592000000L;
            }
        }
        throw new IllegalArgumentException("The method getMillis() is not supported for this type of period: " + this);
    }

    public String toString() {
        return this.period.toString();
    }

    public static enum PeriodEnum {
        DAILY,
        WEEKLY,
        MONTHLY;

    }
}

