/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.order;

import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.dos.OrderExpression;
import de.gsi.financial.samples.dos.Position;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.order.InternalPositionIdGenerator;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResolvePositionService {
    private static final Log logger = LogFactory.getLog(ResolvePositionService.class);

    public static void resolvePositions(Order order, PositionContainer positionContainer) {
        if (!Order.OrderStatus.FILLED.equals((Object)order.getStatus())) {
            throw new IllegalArgumentException("The order has to be filled for position processing. Order id: " + order.getInternalOrderId());
        }
        int restQuantity = order.getOrderExpression().getOrderQuantity();
        ArrayList<Position> newCreatedPositions = new ArrayList<Position>();
        Set<Position> openedPositions = positionContainer.getFastOpenedPositionByMarketSymbol(order.getSymbol());
        int positionTypeReverse = -1 * (order.getOrderExpression().getBuySell().equals((Object)OrderExpression.OrderBuySell.BUY) ? 1 : -1);
        Position[] positionArray = openedPositions.toArray(new Position[0]);
        for (int i = positionArray.length - 1; i >= 0; --i) {
            Position position = positionArray[i];
            if (position.getPositionType() != positionTypeReverse) continue;
            if ((restQuantity -= position.getPositionQuantity()) == 0) {
                ResolvePositionService.closePositionOperation(positionContainer, position, order);
                break;
            }
            if (restQuantity < 0) {
                Position openedPosition = ResolvePositionService.duplicatePosition(position);
                openedPosition.setPositionQuantity(Math.abs(restQuantity));
                newCreatedPositions.add(openedPosition);
                position.setPositionQuantity(position.getPositionQuantity() + restQuantity);
                ResolvePositionService.closePositionOperation(positionContainer, position, order);
                break;
            }
            ResolvePositionService.closePositionOperation(positionContainer, position, order);
        }
        if (restQuantity > 0) {
            Position position = ResolvePositionService.createPositionByOrder(order);
            position.setPositionQuantity(restQuantity);
            newCreatedPositions.add(position);
        }
        for (Position position : newCreatedPositions) {
            positionContainer.addPosition(position);
        }
    }

    private static void closePositionOperation(PositionContainer positionContainer, Position position, Order order) {
        position.setPositionExitIndex(order.getLastActivityTime().getTime());
        position.setExitTime(order.getLastActivityTime());
        position.setExitPrice(order.getAverageFillPrice());
        position.setExitOrder(order);
        position.setPositionStatus(Position.PositionStatus.CLOSED);
        order.setExitOrder(true);
        order.setExitOfPosition(position);
        positionContainer.notifyPositionClosed(position);
    }

    public static double calculatePositionProfitLoss(Position position, double fullpointvalue) {
        return (position.getExitPrice() - position.getEntryPrice()) * (double)position.getPositionType() * (double)position.getPositionQuantity() * fullpointvalue;
    }

    public static Position createPositionByOrder(Order order) {
        if (!Order.OrderStatus.FILLED.equals((Object)order.getStatus())) {
            String message = "The position cannot be created, because order " + order.getInternalOrderId() + "/" + order.getServiceOrderId() + " is not filled.";
            logger.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        int positionType = order.getOrderExpression().getBuySell().equals((Object)OrderExpression.OrderBuySell.BUY) ? 1 : -1;
        Position position = new Position(InternalPositionIdGenerator.generateId(), order.getOrderIndex(), order.getUserName(), order.getLastActivityTime(), positionType, order.getSymbol(), order.getAccountId(), order.getAverageFillPrice(), order.getOrderExpression().getOrderQuantity());
        position.setEntryOrder(order);
        order.setEntryOfPosition(position);
        return position;
    }

    public static Position duplicatePosition(Position position) {
        Position position2 = new Position(InternalPositionIdGenerator.generateId(), position.getPositionEntryIndex(), position.getEntryUserName(), position.getEntryTime(), position.getPositionType(), position.getSymbol(), position.getAccountId(), position.getEntryPrice(), position.getPositionQuantity());
        position2.setPositionStatus(position.getPositionStatus());
        position2.setPositionExitIndex(position.getExitTime() != null ? position.getExitTime().getTime() : -1L);
        position2.setExitTime(position.getExitTime());
        position2.setExitPrice(position.getExitPrice());
        position2.setEntryOrder(position.getEntryOrder());
        position2.setExitOrder(position.getExitOrder());
        return position2;
    }

    private ResolvePositionService() {
    }
}

