/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.order;

import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.dos.OrderExpression;

public class ResolveOrderService {
    public static void resolveOrder(OHLCVItem item, Order order) {
        ResolveOrderService.resolveOrder(item, null, order);
    }

    public static void resolveOrder(OHLCVItem item, OHLCVItem dailyItem, Order order) {
        OrderExpression orderExpression = order.getOrderExpression();
        switch (orderExpression.getOrderType()) {
            case MARKET: {
                switch (orderExpression.getMarketOnPrice()) {
                    case OPEN_PRICE: {
                        order.setAverageFillPrice(item.getOpen());
                        break;
                    }
                    case CLOSE_PRICE: {
                        order.setAverageFillPrice(item.getClose());
                        break;
                    }
                    case TEST_PRICE: {
                        double price = order.getOrderExpression().getPrice();
                        if (ResolveOrderService.isPriceIncluded(item, price)) {
                            order.setAverageFillPrice(price);
                            break;
                        }
                        order.setAverageFillPrice(item.getClose());
                    }
                }
                ResolveOrderService.fillOrderByOhlcvItem(order, item);
                break;
            }
            case LIMIT: 
            case MIT: {
                if (OrderExpression.OrderBuySell.BUY.equals((Object)order.getOrderExpression().getBuySell())) {
                    if (!(item.getLow() <= order.getOrderExpression().getPrice())) break;
                    if (item.getOpen() <= order.getOrderExpression().getPrice()) {
                        order.setAverageFillPrice(item.getOpen());
                    } else {
                        order.setAverageFillPrice(order.getOrderExpression().getPrice());
                    }
                    ResolveOrderService.fillOrderByOhlcvItem(order, item);
                    break;
                }
                if (!(item.getHigh() >= order.getOrderExpression().getPrice())) break;
                if (item.getOpen() >= order.getOrderExpression().getPrice()) {
                    order.setAverageFillPrice(item.getOpen());
                } else {
                    order.setAverageFillPrice(order.getOrderExpression().getPrice());
                }
                ResolveOrderService.fillOrderByOhlcvItem(order, item);
                break;
            }
            case STOP: {
                if (OrderExpression.OrderBuySell.BUY.equals((Object)order.getOrderExpression().getBuySell())) {
                    if (!(item.getHigh() >= order.getOrderExpression().getPrice())) break;
                    if (item.getOpen() >= order.getOrderExpression().getPrice()) {
                        order.setAverageFillPrice(item.getOpen());
                    } else {
                        order.setAverageFillPrice(order.getOrderExpression().getPrice());
                    }
                    ResolveOrderService.fillOrderByOhlcvItem(order, item);
                    break;
                }
                if (!(item.getLow() <= order.getOrderExpression().getPrice())) break;
                if (item.getOpen() <= order.getOrderExpression().getPrice()) {
                    order.setAverageFillPrice(item.getOpen());
                } else {
                    order.setAverageFillPrice(order.getOrderExpression().getPrice());
                }
                ResolveOrderService.fillOrderByOhlcvItem(order, item);
                break;
            }
            case STOP_LIMIT: {
                if (OrderExpression.OrderBuySell.BUY.equals((Object)order.getOrderExpression().getBuySell())) {
                    if (!(item.getHigh() >= order.getOrderExpression().getPrice())) break;
                    if (item.getOpen() <= order.getOrderExpression().getPrice()) {
                        order.setAverageFillPrice(order.getOrderExpression().getPrice());
                        ResolveOrderService.fillOrderByOhlcvItem(order, item);
                        break;
                    }
                    if (item.getOpen() > order.getOrderExpression().getPrice2() && item.getLow() <= order.getOrderExpression().getPrice2()) {
                        order.setAverageFillPrice(order.getOrderExpression().getPrice2());
                        ResolveOrderService.fillOrderByOhlcvItem(order, item);
                    }
                    if (!(item.getOpen() <= order.getOrderExpression().getPrice2())) break;
                    order.setAverageFillPrice(item.getOpen());
                    ResolveOrderService.fillOrderByOhlcvItem(order, item);
                    break;
                }
                if (!(item.getLow() <= order.getOrderExpression().getPrice())) break;
                if (item.getOpen() >= order.getOrderExpression().getPrice()) {
                    order.setAverageFillPrice(order.getOrderExpression().getPrice());
                    ResolveOrderService.fillOrderByOhlcvItem(order, item);
                    break;
                }
                if (item.getOpen() < order.getOrderExpression().getPrice2() && item.getHigh() >= order.getOrderExpression().getPrice2()) {
                    order.setAverageFillPrice(order.getOrderExpression().getPrice2());
                    ResolveOrderService.fillOrderByOhlcvItem(order, item);
                }
                if (!(item.getOpen() >= order.getOrderExpression().getPrice2())) break;
                order.setAverageFillPrice(item.getOpen());
                ResolveOrderService.fillOrderByOhlcvItem(order, item);
                break;
            }
            case MOO: {
                order.setAverageFillPrice(dailyItem != null ? dailyItem.getOpen() : item.getOpen());
                ResolveOrderService.fillOrderByOhlcvItem(order, item);
                break;
            }
            case MOC: {
                order.setAverageFillPrice(dailyItem != null ? dailyItem.getClose() : item.getClose());
                ResolveOrderService.fillOrderByOhlcvItem(order, item);
            }
        }
    }

    public static boolean isPriceIncluded(OHLCVItem item, double price) {
        return price <= item.getHigh() && price >= item.getLow();
    }

    private static void fillOrderByOhlcvItem(Order order, OHLCVItem item) {
        order.setStatus(Order.OrderStatus.FILLED);
        order.setLastActivityTime(item.getTimeStamp());
        order.setOhlcvItem(item);
    }

    private ResolveOrderService() {
    }
}

