/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.order;

import de.gsi.chart.renderer.spi.financial.PositionFinancialRendererPaintAfterEP;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.dos.Position;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.StandardTradePlanAttributes;
import de.gsi.financial.samples.service.execution.ExecutionPlatformListener;
import de.gsi.financial.samples.service.execution.OrderEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionFinancialDataSet
extends AbstractDataSet<PositionFinancialDataSet>
implements ExecutionPlatformListener,
PositionFinancialRendererPaintAfterEP.PositionRenderedAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionFinancialDataSet.class);
    private Map<Long, PositionFinancialRendererPaintAfterEP.PositionRendered> renderedPositionsBased;
    private List<PositionFinancialRendererPaintAfterEP.PositionRendered> renderedPositionsList;
    private String instrument;
    private OhlcvDataSet ohlcvDataSet;

    public PositionFinancialDataSet(String instrument, OhlcvDataSet ohlcvDataSet, AttributeModel context) {
        super(instrument + "-positions", 2);
        this.instrument = instrument;
        this.ohlcvDataSet = ohlcvDataSet;
        this.fillDataSet((PositionContainer)context.getRequiredAttribute(StandardTradePlanAttributes.POSITIONS));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)PositionFinancialDataSet.class.getSimpleName()).log("started '{}'");
        }
    }

    private void fillDataSet(PositionContainer positions) {
        this.renderedPositionsBased = new TreeMap<Long, PositionFinancialRendererPaintAfterEP.PositionRendered>();
        this.renderedPositionsList = new ArrayList<PositionFinancialRendererPaintAfterEP.PositionRendered>();
        Set<Position> positionSet = positions.getPositionByMarketSymbol(this.instrument);
        for (Position position : positionSet) {
            this.includePosition(position, true);
        }
        this.renderedPositionsList.addAll(this.renderedPositionsBased.values());
    }

    private void includePosition(Position position, boolean updateRequired) {
        if (position != null) {
            this.includeRenderedPosition(this.createPositionRendered(position, 1), updateRequired);
            if (position.getPositionStatus() == Position.PositionStatus.CLOSED) {
                this.includeRenderedPosition(this.createPositionRendered(position, 2), updateRequired);
            }
        }
    }

    private void includeRenderedPosition(PositionFinancialRendererPaintAfterEP.PositionRendered positionRendered, boolean updateRequired) {
        PositionFinancialRendererPaintAfterEP.PositionRendered positionRenderedMain = this.renderedPositionsBased.get(positionRendered.index);
        if (positionRenderedMain != null) {
            if (positionRenderedMain.positionId == positionRendered.positionId || !updateRequired) {
                return;
            }
            positionRenderedMain.quantity = positionRendered.entryExit == positionRenderedMain.entryExit ? (positionRenderedMain.quantity += positionRendered.quantity) : (positionRenderedMain.quantity -= positionRendered.quantity);
            positionRenderedMain.price = (positionRenderedMain.price + positionRendered.price) / 2.0;
            positionRenderedMain.joinedEntries.addAll(positionRendered.joinedEntries);
        } else {
            this.renderedPositionsBased.put(positionRendered.index, positionRendered);
            if (!updateRequired) {
                this.renderedPositionsList.add(positionRendered);
            }
        }
    }

    private PositionFinancialRendererPaintAfterEP.PositionRendered createPositionRendered(Position position, int entryExit) {
        PositionFinancialRendererPaintAfterEP.PositionRendered positionRendered = new PositionFinancialRendererPaintAfterEP.PositionRendered();
        positionRendered.positionId = position.getPositionId();
        positionRendered.entryExit = entryExit;
        positionRendered.posType = position.getPositionType();
        positionRendered.quantity = position.getPositionQuantity();
        positionRendered.price = entryExit == 1 ? position.getEntryPrice() : position.getExitPrice();
        boolean bl = positionRendered.closed = position.getPositionStatus() == Position.PositionStatus.CLOSED;
        if (entryExit != 1) {
            this.appendEntryLinkage(position, positionRendered);
        }
        long orderTime = entryExit == 1 ? position.getPositionEntryIndex() : position.getPositionExitIndex();
        positionRendered.index = this.estimateOhlcBasedTimestamp(orderTime);
        return positionRendered;
    }

    private void appendEntryLinkage(Position position, PositionFinancialRendererPaintAfterEP.PositionRendered positionRendered) {
        ArrayList<Double> entryRow = new ArrayList<Double>();
        entryRow.add(Double.valueOf(this.estimateOhlcBasedTimestamp(position.getPositionEntryIndex())));
        entryRow.add(position.getEntryPrice());
        entryRow.add(position.getPositionType() == -1 && position.getEntryPrice() < position.getExitPrice() || position.getPositionType() == 1 && position.getEntryPrice() > position.getExitPrice() ? -1.0 : 1.0);
        positionRendered.joinedEntries.add(entryRow);
    }

    private long estimateOhlcBasedTimestamp(long orderTime) {
        if (this.ohlcvDataSet != null) {
            int idx = this.ohlcvDataSet.getIndex(0, new double[]{(double)orderTime / 1000.0});
            IOhlcvItem ohlcvItem = this.ohlcvDataSet.getItem(idx);
            long ohlcItemTime = ohlcvItem.getTimeStamp().getTime();
            long ohlcItemTimeNext = -1L;
            if (idx < this.ohlcvDataSet.getDataCount() - 1) {
                ohlcItemTimeNext = this.ohlcvDataSet.getItem(idx + 1).getTimeStamp().getTime();
            }
            if (orderTime <= ohlcItemTime) {
                orderTime = Math.round((double)ohlcItemTime / 1000.0);
            } else if (orderTime > ohlcItemTimeNext) {
                orderTime = Math.round((double)ohlcItemTimeNext / 1000.0);
            }
        }
        return orderTime;
    }

    public PositionFinancialRendererPaintAfterEP.PositionRendered getPositionByTime(long corr) {
        return this.renderedPositionsBased.get(corr);
    }

    public double get(int dimIndex, int index) {
        PositionFinancialRendererPaintAfterEP.PositionRendered positionRendered = this.renderedPositionsList.get(index);
        if (dimIndex == 0) {
            return positionRendered == null ? -1.0 : (double)positionRendered.index;
        }
        return positionRendered == null ? -1.0 : positionRendered.price;
    }

    public int getDataCount() {
        return this.renderedPositionsList.size();
    }

    public DataSet set(DataSet other, boolean copy) {
        this.renderedPositionsBased = new TreeMap<Long, PositionFinancialRendererPaintAfterEP.PositionRendered>(((PositionFinancialDataSet)other).renderedPositionsBased);
        this.renderedPositionsList = new ArrayList<PositionFinancialRendererPaintAfterEP.PositionRendered>(((PositionFinancialDataSet)other).renderedPositionsList);
        this.instrument = ((PositionFinancialDataSet)other).instrument;
        this.ohlcvDataSet = ((PositionFinancialDataSet)other).ohlcvDataSet;
        return this;
    }

    @Override
    public void orderFilled(OrderEvent event) {
        Order order = event.getOrder();
        this.includePosition(order.isExitOrder() ? order.getExitOfPosition() : order.getEntryOfPosition(), false);
        this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this, "filled-order"));
    }

    @Override
    public void orderCancelled(OrderEvent event) {
    }
}

