/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.execution;

import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.dos.OrderExpression;
import de.gsi.financial.samples.service.OhlcvChangeListener;
import de.gsi.financial.samples.service.execution.AbstractExecutionPlatform;
import de.gsi.financial.samples.service.execution.ExecutionResult;
import de.gsi.financial.samples.service.order.ResolveOrderService;
import de.gsi.financial.samples.service.order.ResolvePositionService;
import java.util.Date;

public class BacktestExecutionPlatform
extends AbstractExecutionPlatform
implements OhlcvChangeListener {
    private OHLCVItem ohlcvItem;

    @Override
    protected ExecutionResult ensureRequiredOrderAttributes(Order order) {
        return new ExecutionResult(order);
    }

    @Override
    protected ExecutionResult executeOrderCancellation(Order order) {
        ExecutionResult result = new ExecutionResult(order);
        if (Order.OrderStatus.OPENED.equals((Object)order.getStatus())) {
            order.setStatus(Order.OrderStatus.CANCELLED);
            order.setLastActivityTime(this.getActualTime());
            this.orders.removeOrder(order);
            this.fireOrderCancelled(order);
        } else {
            result.setResult(ExecutionResult.ExecutionResultEnum.ERROR);
            result.setErrorMessage("The order " + order.getInternalOrderId() + " is not possible to cancel. The order is not opened.");
        }
        return result;
    }

    @Override
    protected ExecutionResult executeOrder(Order order) {
        if (OrderExpression.OrderType.MARKET.equals((Object)order.getOrderExpression().getOrderType())) {
            this.resolveOrder(order);
        }
        return new ExecutionResult(order);
    }

    protected void resolveOrder(Order order) {
        ResolveOrderService.resolveOrder(this.getActualOhlcvItem(), null, order);
        if (Order.OrderStatus.FILLED.equals((Object)order.getStatus())) {
            this.orders.removeOpenedOrder(order);
            ResolvePositionService.resolvePositions(order, this.positions);
            this.fireOrderFilled(order);
        }
    }

    protected Date getActualTime() {
        return this.ohlcvItem.getTimeStamp();
    }

    protected OHLCVItem getActualOhlcvItem() {
        return this.ohlcvItem;
    }

    @Override
    public void tickEvent(IOhlcvItem ohlcvItem) {
        this.ohlcvItem = (OHLCVItem)ohlcvItem;
    }
}

