/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.consolidate;

import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.consolidate.AbstractIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.OhlcvTimeframeConsolidation;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.util.Calendar;
import java.util.Date;

public class TimePeriodIncrementalOhlcvConsolidation
extends AbstractIncrementalOhlcvConsolidation {
    private final Calendar calFrom = Calendar.getInstance();
    private final Calendar calTo = Calendar.getInstance();

    public TimePeriodIncrementalOhlcvConsolidation(OhlcvTimeframeConsolidation.OhlcvConsolidationComputation consolidationComputation, IntradayPeriod period, Interval<Calendar> tt, OhlcvConsolidationAddon[] _ohlcvConsolidationAddons) {
        super(consolidationComputation, period, tt, _ohlcvConsolidationAddons);
        this.calFrom.setFirstDayOfWeek(1);
        this.calTo.setFirstDayOfWeek(1);
    }

    @Override
    protected void defineConsolidationConditionAfterAddition(OHLCVItem finalItem) {
        this.defineTimeInterval(this.calFrom, this.calTo, finalItem.getTimeStamp(), this.period);
    }

    @Override
    protected void defineConsolidationConditionAfterUpdate(OHLCVItem finalItem) {
    }

    @Override
    protected boolean checkConsolidationCondition(OHLCVItem lastItem, OHLCVItem incrementItem) {
        Date incrementTimestamp = incrementItem.getTimeStamp();
        return incrementTimestamp.getTime() <= this.calTo.getTimeInMillis() && incrementTimestamp.getTime() > this.calFrom.getTimeInMillis();
    }

    @Override
    protected OHLCVItem processConsolidation(OHLCVItem lastItem, OHLCVItem incrementItem) {
        return this.consolidationComputation.consolidate(this.calTo.getTime(), lastItem, incrementItem);
    }

    private void defineTimeInterval(Calendar calFrom, Calendar calTo, Date aDate, IntradayPeriod period) {
        double toTime;
        double periodValue = period.getPeriodValue();
        IntradayPeriod.IntradayPeriodEnum intradayPeriodEnum = period.getPeriod();
        switch (intradayPeriodEnum) {
            case S: {
                toTime = 1000.0;
                break;
            }
            case M: {
                toTime = 60000.0;
                break;
            }
            case H: {
                toTime = 3600000.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("This type of Intraday period is not supported!");
            }
        }
        Calendar ttStart = Calendar.getInstance();
        ttStart.setTime(aDate);
        ttStart.set(11, this.tt == null ? 0 : ((Calendar)this.tt.from).get(11));
        ttStart.set(12, this.tt == null ? 0 : ((Calendar)this.tt.from).get(12));
        ttStart.set(13, 0);
        ttStart.set(14, 0);
        double ttEndTime = -1.0;
        if (this.tt != null) {
            Calendar ttEnd = Calendar.getInstance();
            ttEnd.setTime(aDate);
            ttEnd.set(11, ((Calendar)this.tt.to).get(11));
            ttEnd.set(12, ((Calendar)this.tt.to).get(12));
            ttEnd.set(13, 59);
            ttEnd.set(14, 999999999);
            ttEndTime = (double)ttEnd.getTime().getTime() / toTime;
        }
        double aDateTime = (double)aDate.getTime() / toTime;
        double ttStartTime = (double)ttStart.getTime().getTime() / toTime;
        double diff = aDateTime - ttStartTime;
        double n = Math.floor(diff / periodValue);
        double resampleFrom = ttStartTime + periodValue * (diff % periodValue == 0.0 ? n - 1.0 : n);
        double resampleTo = resampleFrom + periodValue;
        if (this.tt != null && resampleTo >= ttEndTime) {
            resampleTo = ttEndTime;
        }
        calFrom.setTime(new Date(Math.round(resampleFrom * toTime)));
        calTo.setTime(new Date(Math.round(resampleTo * toTime)));
    }
}

