/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service;

import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcv;
import de.gsi.dataset.utils.StreamUtils;
import de.gsi.financial.samples.dos.DefaultOHLCV;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.ConcurrentDateFormatAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Stream;

public class SimpleOhlcvDailyParser {
    private static final String CHART_SAMPLE_PATH = "classpath:de/gsi/chart/samples/financial/%s.csv";
    private static final ConcurrentDateFormatAccess dateFormatParsing = new ConcurrentDateFormatAccess("MM/dd/yyyy HH:mm");
    private static final ConcurrentDateFormatAccess olderDateFormatParsing = new ConcurrentDateFormatAccess("MM/dd/yyyy HHmm");

    public IOhlcv getContinuousOHLCV(String future) throws IOException, NumberFormatException {
        String resource = String.format(CHART_SAMPLE_PATH, future);
        try (InputStreamReader is = new InputStreamReader(StreamUtils.getInputStream((String)resource));){
            IOhlcv iOhlcv;
            try (BufferedReader br = new BufferedReader(is);){
                iOhlcv = SimpleOhlcvDailyParser.convertTsRowStream(future, br.lines(), new DailyOhlcvItemRowParser());
            }
            return iOhlcv;
        }
    }

    private static IOhlcv convertTsRowStream(String title, Stream<String> rowStream, TradeStationRowParser parser) throws NumberFormatException {
        TSConvertSettings ref = new TSConvertSettings(true, true);
        String symbol = new File(title).getName().replaceFirst("[.][^.]+$", "");
        Calendar cal = Calendar.getInstance();
        ArrayList<OHLCVItem> items = new ArrayList<OHLCVItem>();
        DefaultOHLCV ohlcvOutput = new DefaultOHLCV();
        ohlcvOutput.setTitle(title);
        ohlcvOutput.setName(title);
        ohlcvOutput.setAssetName(title);
        ohlcvOutput.setSymbol(symbol);
        rowStream.forEach(r -> {
            OHLCVItem ohlcvItem = parser.parse(ref, cal, (String)r);
            if (ohlcvItem == null) {
                return;
            }
            items.add(ohlcvItem);
        });
        ohlcvOutput.addOhlcvItems(items);
        return ohlcvOutput;
    }

    private static class DailyOhlcvItemRowParser
    implements TradeStationRowParser {
        private DailyOhlcvItemRowParser() {
        }

        @Override
        public OHLCVItem parse(TSConvertSettings ref, Calendar cal, String r) {
            Date timestamp;
            if (ref.header) {
                ref.header = false;
                return null;
            }
            String[] row = r.split(",");
            try {
                timestamp = ref.useNewStyle ? dateFormatParsing.parse(row[0] + " " + row[1]) : olderDateFormatParsing.parse(row[0] + " " + row[1]);
            }
            catch (ParseException e) {
                try {
                    timestamp = olderDateFormatParsing.parse(row[0] + " " + row[1]);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException("Wrong format of daily data row=" + row[0] + " " + row[1]);
                }
                ref.useNewStyle = false;
            }
            return new OHLCVItem(timestamp, Double.parseDouble(row[2]), Double.parseDouble(row[3]), Double.parseDouble(row[4]), Double.parseDouble(row[5]), Double.parseDouble(row[6]), Double.parseDouble(row[7]));
        }
    }

    @FunctionalInterface
    private static interface TradeStationRowParser {
        public OHLCVItem parse(TSConvertSettings var1, Calendar var2, String var3);
    }

    private static class TSConvertSettings {
        boolean header;
        boolean useNewStyle;

        public TSConvertSettings(boolean header, boolean useNewStyle) {
            this.header = header;
            this.useNewStyle = useNewStyle;
        }
    }
}

