/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service;

import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.TickDataFinishedException;
import de.gsi.financial.samples.service.TickOhlcvDataProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.Date;
import javafx.beans.property.DoubleProperty;

public class SCIDByNio {
    private FileChannel fileChannel;
    private ByteBuffer bufferHeader;
    private ByteBuffer bufferRecordDouble;
    private ByteBuffer bufferRecordFloat;
    private ByteBuffer bufferRecordULong;
    private final Calendar cal = Calendar.getInstance();
    private int timeZone;
    private String title;
    private String symbol;

    public void openNewChannel(String resource) throws IOException {
        this.title = new File(resource).getName();
        this.symbol = this.title.replaceFirst("[.][^.]+$", "");
        this.timeZone = this.cal.get(15);
        File f = new File(resource);
        FileInputStream fis = new FileInputStream(f);
        this.fileChannel = fis.getChannel();
        this.bufferHeader = ByteBuffer.allocate(4);
        this.bufferHeader.order(ByteOrder.LITTLE_ENDIAN);
        this.bufferRecordDouble = ByteBuffer.allocate(8);
        this.bufferRecordDouble.order(ByteOrder.LITTLE_ENDIAN);
        this.bufferRecordFloat = ByteBuffer.allocate(4);
        this.bufferRecordFloat.order(ByteOrder.LITTLE_ENDIAN);
        this.bufferRecordULong = ByteBuffer.allocate(4);
        this.bufferRecordULong.order(ByteOrder.LITTLE_ENDIAN);
        this.fileChannel.position(56L);
    }

    public void closeActualChannel() throws IOException {
        if (this.fileChannel.isOpen()) {
            this.fileChannel.close();
        }
    }

    public long findPositionByTimestamp(Date timestamp) throws IOException {
        long lo = 56L;
        long hi = this.fileChannel.size() - 40L;
        while (lo <= hi) {
            long mid = lo + (hi - lo) / 2L;
            Date midTimestamp = this.loadTimestamp(mid = (mid - 56L) / 40L * 40L + 56L);
            if (timestamp.before(midTimestamp)) {
                hi = mid - 40L;
                continue;
            }
            if (timestamp.after(midTimestamp)) {
                lo = mid + 40L;
                continue;
            }
            return mid;
        }
        return -lo;
    }

    public long ensureNearestTimestampPosition(Date timestamp) throws IOException {
        long positionEnd;
        long position = this.findPositionByTimestamp(timestamp);
        if (position > 0L) {
            return position;
        }
        if ((position = Math.abs(position)) > (positionEnd = this.fileChannel.size() - 40L)) {
            return positionEnd;
        }
        return position;
    }

    public TickOhlcvDataProvider createTickDataReplayStream(Interval<Calendar> requiredTimestamps, Date replayStarTime, final DoubleProperty replaySpeed) throws IOException {
        long positionStart = this.ensureNearestTimestampPosition(((Calendar)requiredTimestamps.from).getTime());
        final long positionEnd = this.ensureNearestTimestampPosition(((Calendar)requiredTimestamps.to).getTime());
        final long ohlcvReplayStartIndex = this.ensureNearestTimestampPosition(replayStarTime);
        this.fileChannel.position(positionStart);
        return new TickOhlcvDataProvider(){
            private OHLCVItem prevItem = null;
            private OHLCVItem item = null;
            private final Object lock = new Object();

            @Override
            public OHLCVItem get() throws TickDataFinishedException, IOException {
                long position = SCIDByNio.this.fileChannel.position();
                if (positionEnd != -1L && position >= positionEnd) {
                    throw new TickDataFinishedException("The replay finished.");
                }
                if (position >= ohlcvReplayStartIndex) {
                    long prevTime = this.prevItem != null ? this.prevItem.getTimeStamp().getTime() : 0L;
                    long time = this.item != null ? this.item.getTimeStamp().getTime() : 0L;
                    long waitingTime = Math.round((double)(time - prevTime) / replaySpeed.get());
                    waitingTime = waitingTime < 1L ? 1L : waitingTime;
                    try {
                        Thread.sleep(waitingTime);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.prevItem = this.item;
                this.item = SCIDByNio.this.loadOhlcvItemRealtime();
                return this.item;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OHLCVItem loadOhlcvItemRealtime() throws IOException {
        float close;
        int bytesRead;
        do {
            if ((bytesRead = this.fileChannel.read(this.bufferRecordDouble)) != -1) continue;
            SCIDByNio sCIDByNio = this;
            synchronized (sCIDByNio) {
                try {
                    this.wait(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (bytesRead == -1);
        this.bufferRecordDouble.flip();
        double dt = this.bufferRecordDouble.getDouble();
        this.bufferRecordDouble.clear();
        this.fileChannel.read(this.bufferRecordFloat);
        this.bufferRecordFloat.clear();
        this.fileChannel.read(this.bufferRecordFloat);
        this.bufferRecordFloat.flip();
        float high = this.bufferRecordFloat.getFloat();
        this.bufferRecordFloat.clear();
        this.fileChannel.read(this.bufferRecordFloat);
        this.bufferRecordFloat.flip();
        float low = this.bufferRecordFloat.getFloat();
        this.bufferRecordFloat.clear();
        this.fileChannel.read(this.bufferRecordFloat);
        this.bufferRecordFloat.flip();
        float open = close = this.bufferRecordFloat.getFloat();
        this.bufferRecordFloat.clear();
        this.fileChannel.read(this.bufferRecordULong);
        this.bufferRecordULong.flip();
        this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        this.fileChannel.read(this.bufferRecordULong);
        this.bufferRecordULong.flip();
        long totalVolume = this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        this.fileChannel.read(this.bufferRecordULong);
        this.bufferRecordULong.flip();
        long bidVolume = this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        this.fileChannel.read(this.bufferRecordULong);
        this.bufferRecordULong.flip();
        long askVolume = this.bufferRecordULong.getInt();
        this.bufferRecordULong.clear();
        Date timestamp = new Date(this.convertWindowsTimeToMilliseconds(dt));
        return new OHLCVItem(timestamp, open, high, low, close, totalVolume, 0.0, askVolume, bidVolume);
    }

    private Date loadTimestamp(long position) throws IOException {
        this.fileChannel.position(position);
        int bytesRead = this.fileChannel.read(this.bufferRecordDouble);
        if (bytesRead == -1) {
            return null;
        }
        this.bufferRecordDouble.flip();
        double dt = this.bufferRecordDouble.getDouble();
        this.bufferRecordDouble.clear();
        return new Date(this.convertWindowsTimeToMilliseconds(dt));
    }

    public long convertWindowsTimeToMilliseconds(double comTime) {
        long result = Math.round(8.64E7 * (comTime -= 25569.0)) - (long)this.timeZone;
        this.cal.setTime(new Date(result));
        return result -= (long)this.cal.get(16);
    }
}

