/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.financial.samples.dos.PriceVolume;
import java.util.Collection;
import java.util.TreeMap;

public class PriceVolumeContainer {
    private final TreeMap<Double, PriceVolume> priceVolumeMap = new TreeMap();
    private double pocPrice;
    private double pocVolume = -1.7976931348623157E308;

    public void addPriceVolume(double price, double volumeDown, double volumeUp) {
        PriceVolume priceVolume = this.priceVolumeMap.get(price);
        if (priceVolume == null) {
            priceVolume = new PriceVolume(price, volumeDown, volumeUp);
            this.priceVolumeMap.put(price, priceVolume);
        } else {
            priceVolume.volumeUp += volumeUp;
            priceVolume.volumeDown += volumeDown;
        }
        double totalVolume = priceVolume.volumeUp + priceVolume.volumeDown;
        if (totalVolume > this.pocVolume) {
            this.pocVolume = totalVolume;
            this.pocPrice = price;
        }
    }

    public PriceVolume getPriceVolumeBy(double price) {
        return this.priceVolumeMap.get(price);
    }

    public TreeMap<Double, PriceVolume> getCompletedPriceVolumeTreeMap() {
        return this.priceVolumeMap;
    }

    public Collection<PriceVolume> getCompletedPriceVolume() {
        return this.priceVolumeMap.values();
    }

    public void clear() {
        this.priceVolumeMap.clear();
        this.pocVolume = -1.7976931348623157E308;
        this.pocPrice = 0.0;
    }

    public double getPocPrice() {
        return this.pocPrice;
    }

    public double getPocVolume() {
        return this.pocVolume;
    }
}

