/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.financial.samples.dos.Position;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PositionContainer
implements Serializable {
    private static final long serialVersionUID = -6964168549256831250L;
    private Map<Integer, Position> positionIdMap = new HashMap<Integer, Position>();
    private Map<String, Set<Position>> positionMap = new HashMap<String, Set<Position>>();
    private Map<String, Set<Position>> openPositionMap = new HashMap<String, Set<Position>>();
    private Map<String, Set<Position>> strategyPositionMap = new HashMap<String, Set<Position>>();
    private Map<String, Set<Position>> strategyOpenPositionMap = new HashMap<String, Set<Position>>();

    public void addPosition(Position position) {
        this.positionIdMap.put(position.getPositionId(), position);
        Set positionSet = this.positionMap.computeIfAbsent(position.getSymbol(), k -> new LinkedHashSet());
        this.addAndReplaceSet(positionSet, position);
        String strategy = position.getStrategy();
        if (strategy != null) {
            positionSet = this.strategyPositionMap.computeIfAbsent(strategy, k -> new LinkedHashSet());
            this.addAndReplaceSet(positionSet, position);
        }
        if (position.getPositionStatus() == Position.PositionStatus.OPENED) {
            positionSet = this.openPositionMap.computeIfAbsent(position.getSymbol(), k -> new LinkedHashSet());
            this.addAndReplaceSet(positionSet, position);
            if (strategy != null) {
                positionSet = this.strategyOpenPositionMap.computeIfAbsent(strategy, k -> new LinkedHashSet());
                this.addAndReplaceSet(positionSet, position);
            }
        } else {
            this.notifyPositionClosed(position);
        }
    }

    private void addAndReplaceSet(Set<Position> positionSet, Position position) {
        if (!positionSet.add(position)) {
            positionSet.remove(position);
            positionSet.add(position);
        }
    }

    public boolean removePosition(Position position) {
        Set<Position> positionSet;
        this.positionIdMap.remove(position.getPositionId());
        String strategy = position.getStrategy();
        if (position.getPositionStatus() == Position.PositionStatus.OPENED) {
            positionSet = this.openPositionMap.get(position.getSymbol());
            if (positionSet != null) {
                positionSet.remove(position);
            }
            if (strategy != null && (positionSet = this.strategyOpenPositionMap.get(strategy)) != null) {
                positionSet.remove(position);
            }
        }
        if (strategy != null && (positionSet = this.positionMap.get(strategy)) != null) {
            positionSet.remove(position);
        }
        return (positionSet = this.positionMap.get(position.getSymbol())) != null && positionSet.remove(position);
    }

    public void notifyPositionClosed(Position position) {
        Set<Position> positionSet = this.openPositionMap.get(position.getSymbol());
        if (positionSet != null) {
            positionSet.remove(position);
        }
        if (position.getStrategy() != null && (positionSet = this.strategyOpenPositionMap.get(position.getStrategy())) != null) {
            positionSet.remove(position);
        }
    }

    public int size() {
        int size = 0;
        for (Set<Position> positions : this.positionMap.values()) {
            size += positions.size();
        }
        return size;
    }

    public int size(String symbol) {
        Set<Position> positions = this.positionMap.get(symbol);
        return positions == null ? 0 : positions.size();
    }

    public int sizeByStrategy(String strategy) {
        Set<Position> positions = this.strategyPositionMap.get(strategy);
        return positions == null ? 0 : positions.size();
    }

    public void clear() {
        this.positionIdMap = new HashMap<Integer, Position>();
        this.positionMap = new HashMap<String, Set<Position>>();
        this.openPositionMap = new HashMap<String, Set<Position>>();
        this.strategyPositionMap = new HashMap<String, Set<Position>>();
        this.strategyOpenPositionMap = new HashMap<String, Set<Position>>();
    }

    public Position getPositionById(int positionId) {
        return this.positionIdMap.get(positionId);
    }

    public Set<Position> getPositionByMarketSymbol(String symbol) {
        Set<Position> positions = null;
        if (symbol != null) {
            positions = this.positionMap.get(symbol);
        }
        if (positions == null) {
            positions = new LinkedHashSet<Position>();
        }
        return positions;
    }

    public Set<Position> getPositionByStrategy(String strategy) {
        Set<Position> positions = null;
        if (strategy != null) {
            positions = this.strategyPositionMap.get(strategy);
        }
        if (positions == null) {
            positions = new LinkedHashSet<Position>();
        }
        return positions;
    }

    public List<Position> getAllPositionList() {
        ArrayList<Position> positionList = new ArrayList<Position>();
        for (Set<Position> positions : this.positionMap.values()) {
            positionList.addAll(positions);
        }
        return positionList;
    }

    public List<Position> getAllPositionListTimeOrdered() {
        List<Position> positionList = this.getAllPositionList();
        positionList.sort(Comparator.comparing(Position::getExitTime));
        return positionList;
    }

    public List<Position> getPositionListByMarketSymbol(String symbol) {
        return new ArrayList<Position>(this.getPositionByMarketSymbol(symbol));
    }

    public List<Position> getPositionListByStrategy(String strategy) {
        return new ArrayList<Position>(this.getPositionByStrategy(strategy));
    }

    public Set<Position> getFastOpenedPositionByMarketSymbol(String symbol) {
        Set<Position> openedPositionSet = this.openPositionMap.get(symbol);
        if (openedPositionSet == null) {
            return new LinkedHashSet<Position>();
        }
        return openedPositionSet;
    }

    public Set<Position> getFastOpenedPositionByStrategy(String strategy) {
        Set<Position> openedPositionSet = this.strategyOpenPositionMap.get(strategy);
        if (openedPositionSet == null) {
            return new LinkedHashSet<Position>();
        }
        return openedPositionSet;
    }

    public List<Position> getOpenedPositionsByMarketSymbol(String symbol) {
        return this.getPositionStatusByMarketSymbol(symbol, Position.PositionStatus.OPENED);
    }

    public List<Position> getClosedPositionsByMarketSymbol(String symbol) {
        return this.getPositionStatusByMarketSymbol(symbol, Position.PositionStatus.CLOSED);
    }

    public List<Position> getOpenedPositionsByStrategy(String strategy) {
        return this.getPositionStatusByStrategy(strategy, Position.PositionStatus.OPENED);
    }

    public List<Position> getClosedPositionsByStrategy(String strategy) {
        return this.getPositionStatusByStrategy(strategy, Position.PositionStatus.CLOSED);
    }

    public List<Position> getClosedPositions() {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (String symbol : this.getTradedMarketSymbols()) {
            positions.addAll(this.getPositionStatusByMarketSymbol(symbol, Position.PositionStatus.CLOSED));
        }
        return positions;
    }

    private List<Position> getPositionStatusByMarketSymbol(String symbol, Position.PositionStatus positionStatus) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Position position : this.getPositionByMarketSymbol(symbol)) {
            if (!positionStatus.equals((Object)position.getPositionStatus())) continue;
            positions.add(position);
        }
        return positions;
    }

    private List<Position> getPositionStatusByStrategy(String strategy, Position.PositionStatus positionStatus) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Position position : this.getPositionByStrategy(strategy)) {
            if (!positionStatus.equals((Object)position.getPositionStatus())) continue;
            positions.add(position);
        }
        return positions;
    }

    public Set<String> getTradedMarketSymbols() {
        return this.positionMap.keySet();
    }

    public Set<String> getTradedStrategies() {
        return this.strategyPositionMap.keySet();
    }

    public boolean contains(Position position) {
        Set<Position> positionSet = this.getPositionByMarketSymbol(position.getSymbol());
        return positionSet.contains(position);
    }

    public void compare(PositionContainer positionContainer) throws IllegalStateException {
        for (String market : this.positionMap.keySet()) {
            Set<Position> positions = this.getPositionByMarketSymbol(market);
            Set<Position> otherPositions = positionContainer.getPositionByMarketSymbol(market);
            if (positions.size() != otherPositions.size()) {
                throw new IllegalStateException("The size of position containers is different " + positions.size() + "; " + otherPositions.size());
            }
            for (Position otherPosition : otherPositions) {
                if (positions.contains(otherPosition)) {
                    boolean found = false;
                    for (Position position : positions) {
                        if (!position.equals(otherPosition)) continue;
                        if (!position.comparePosition(otherPosition)) {
                            throw new IllegalStateException("The positions are different " + otherPosition + ", " + position);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IllegalStateException("The position doesn't exist " + otherPosition);
                }
                throw new IllegalStateException("The position doesn't exist " + otherPosition);
            }
        }
    }

    public String toString() {
        return this.positionMap.values().toString();
    }

    public String toLineString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PositionContainer {").append(System.lineSeparator());
        for (Position position : this.getAllPositionListTimeOrdered()) {
            sb.append(position).append(System.lineSeparator());
        }
        sb.append("}").append(System.lineSeparator());
        return sb.toString();
    }
}

