/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.service.ConcurrentDateFormatAccess;
import de.gsi.financial.samples.service.period.Period;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.DateUtils;

public class Position
implements Comparable<Position>,
Serializable {
    private static final long serialVersionUID = -7967285725003509765L;
    public static final ConcurrentDateFormatAccess dateFormat = new ConcurrentDateFormatAccess("MM/dd/yyyy HH:mm:ss");
    private final int positionId;
    private final long positionEntryIndex;
    private long positionExitIndex = -1L;
    private Integer timePosId;
    private final Date entryTime;
    private Date exitTime;
    private final int positionType;
    private PositionStatus positionStatus = PositionStatus.OPENED;
    private final String symbol;
    private String strategy;
    private final String entryUserName;
    private final String accountId;
    private int positionQuantity;
    private final Double entryPrice;
    private Double exitPrice;
    private Double mae;
    private Double mfe;
    private Double risk;
    private boolean isLive = false;
    private Double pl;
    private Period period;
    private transient Order entryOrder;
    private transient Order exitOrder;
    private transient AttributeModel addons;

    public Position(int positionId, Long positionEntryIndex, String entryUserName, Date entryTime, int positionType, String symbol, String accountId, Double entryPrice, int positionQuantity) {
        this.positionId = positionId;
        this.positionEntryIndex = positionEntryIndex == null ? entryTime.getTime() : positionEntryIndex.longValue();
        this.entryUserName = entryUserName;
        this.entryTime = entryTime;
        this.positionType = positionType;
        this.symbol = symbol;
        this.accountId = accountId;
        this.entryPrice = entryPrice;
        this.positionQuantity = positionQuantity;
    }

    public Position(int positionId, Long positionIndex, String entryUserName, String strategy, Date entryTime, int positionType, String symbol, String accountId, Double entryPrice, int positionQuantity) {
        this(positionId, positionIndex, entryUserName, entryTime, positionType, symbol, accountId, entryPrice, positionQuantity);
        this.strategy = strategy;
    }

    public Position copyDeep() {
        return (Position)SerializationUtils.clone((Serializable)this);
    }

    public Order getEntryOrder() {
        return this.entryOrder;
    }

    public void setEntryOrder(Order entryOrder) {
        this.entryOrder = entryOrder;
    }

    public Order getExitOrder() {
        return this.exitOrder;
    }

    public AttributeModel getAddons() {
        if (this.addons == null) {
            this.addons = new AttributeModel();
        }
        return this.addons;
    }

    public void setExitOrder(Order exitOrder) {
        this.exitOrder = exitOrder;
    }

    public Double getMfe() {
        return this.mfe;
    }

    public void setMfe(Double mfe) {
        this.mfe = mfe;
    }

    public int getPositionQuantity() {
        return this.positionQuantity;
    }

    public String getEntryUserName() {
        return this.entryUserName;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public void setPositionQuantity(int positionQuantity) {
        this.positionQuantity = positionQuantity;
    }

    public Date getExitTime() {
        return this.exitTime;
    }

    public void setPositionExitIndex(long positionExitIndex) {
        this.positionExitIndex = positionExitIndex;
    }

    public long getPositionExitIndex() {
        return this.positionExitIndex;
    }

    public void setExitTime(Date exitTime) {
        this.exitTime = exitTime;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setLive(boolean live) {
        this.isLive = live;
    }

    public Double getMae() {
        return this.mae;
    }

    public void setMae(Double mae) {
        this.mae = mae;
    }

    public Double getRisk() {
        return this.risk;
    }

    public void setRisk(Double risk) {
        this.risk = risk;
    }

    public PositionStatus getPositionStatus() {
        return this.positionStatus;
    }

    public void setPositionStatus(PositionStatus positionStatus) {
        this.positionStatus = positionStatus;
    }

    public Double getExitPrice() {
        return this.exitPrice;
    }

    public void setExitPrice(Double exitPrice) {
        this.exitPrice = exitPrice;
    }

    public int getPositionId() {
        return this.positionId;
    }

    public long getPositionEntryIndex() {
        return this.positionEntryIndex;
    }

    public Date getEntryTime() {
        return this.entryTime;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Double getEntryPrice() {
        return this.entryPrice;
    }

    public Double getPl() {
        return this.pl;
    }

    public void setPl(Double pl) {
        this.pl = pl;
    }

    public Integer getTimePosId() {
        return this.timePosId;
    }

    public void setTimePosId(Integer timePosId) {
        this.timePosId = timePosId;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    @Override
    public int compareTo(Position o) {
        return this.positionId - o.positionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.positionId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        return this.positionId == other.positionId;
    }

    public boolean comparePosition(Position position) {
        if (this == position) {
            return true;
        }
        if (position == null) {
            return false;
        }
        if (this.getClass() != position.getClass()) {
            return false;
        }
        Position other = position;
        if (this.positionEntryIndex != other.positionEntryIndex) {
            return false;
        }
        if (this.positionExitIndex != other.positionExitIndex) {
            return false;
        }
        if (this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId)) {
            return false;
        }
        if (this.entryPrice == null ? other.entryPrice != null : !this.entryPrice.equals(other.entryPrice)) {
            return false;
        }
        if (this.entryTime == null ? other.entryTime != null : !DateUtils.truncatedEquals((Date)this.entryTime, (Date)other.entryTime, (int)12)) {
            return false;
        }
        if (this.entryUserName == null ? other.entryUserName != null : !this.entryUserName.equals(other.entryUserName)) {
            return false;
        }
        if (this.strategy == null ? other.strategy != null : !this.strategy.equals(other.strategy)) {
            return false;
        }
        if (this.exitPrice == null ? other.exitPrice != null : !this.exitPrice.equals(other.exitPrice)) {
            return false;
        }
        if (this.exitTime == null ? other.exitTime != null : !DateUtils.truncatedEquals((Date)this.exitTime, (Date)other.exitTime, (int)12)) {
            return false;
        }
        if (this.mae == null ? other.mae != null : !this.mae.equals(other.mae)) {
            return false;
        }
        if (this.risk == null ? other.risk != null : !this.risk.equals(other.risk)) {
            return false;
        }
        if (this.mfe == null ? other.mfe != null : !this.mfe.equals(other.mfe)) {
            return false;
        }
        if (this.isLive != other.isLive) {
            return false;
        }
        if (this.pl == null ? other.pl != null : !this.pl.equals(other.pl)) {
            return false;
        }
        if (this.timePosId == null ? other.timePosId != null : !this.timePosId.equals(other.timePosId)) {
            return false;
        }
        if (this.period == null ? other.period != null : !this.period.equals(other.period)) {
            return false;
        }
        if (this.positionId != other.positionId) {
            return false;
        }
        if (this.positionQuantity != other.positionQuantity) {
            return false;
        }
        if (this.positionStatus != other.positionStatus) {
            return false;
        }
        if (this.positionType != other.positionType) {
            return false;
        }
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    public String toString() {
        return "Position [positionId=" + this.positionId + ", positionEntryIndex=" + this.positionEntryIndex + ", positionExitIndex=" + this.positionExitIndex + ", timePosId=" + this.timePosId + ", entryUserName=" + this.entryUserName + ", strategy=" + this.strategy + ", entryTime=" + (this.entryTime != null ? dateFormat.format(this.entryTime) : "NO ENTRY") + ", exitTime=" + (this.exitTime != null ? dateFormat.format(this.exitTime) : "NO EXIT") + ", positionType=" + this.positionType + ", positionStatus=" + this.positionStatus + ", symbol=" + this.symbol + ", accountId=" + this.accountId + ", positionQuantity=" + this.positionQuantity + ", entryPrice=" + this.entryPrice + ", exitPrice=" + this.exitPrice + ", MFE=" + this.mfe + ", MAE=" + this.mae + ", risk=" + this.risk + ", period=" + this.period + ", pl=" + this.pl + ", isLive=" + this.isLive + "]";
    }

    public static enum PositionStatus {
        OPENED,
        CLOSED;

    }
}

