/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.dos.OrderExpression;
import de.gsi.financial.samples.dos.Position;
import java.util.Date;

public class Order {
    private final int internalOrderId;
    private final long orderIndex;
    private final String userName;
    private final Date entryTime;
    private final String symbol;
    private final OrderExpression orderExpression;
    private final String accountId;
    private String serviceOrderId;
    private Date lastActivityTime;
    private OrderStatus status = OrderStatus.OPENED;
    private double averageFillPrice;
    private OHLCVItem ohlcvItem;
    private boolean isExitOrder = false;
    private Position entryOfPosition;
    private Position exitOfPosition;

    public Order(int internalOrderId, Long orderIndex, String userName, Date entryTime, String symbol, OrderExpression orderExpression, String accountId) {
        this.internalOrderId = internalOrderId;
        this.orderIndex = orderIndex == null ? entryTime.getTime() : orderIndex.longValue();
        this.userName = userName;
        this.entryTime = entryTime;
        this.symbol = symbol;
        this.orderExpression = orderExpression;
        this.accountId = accountId;
        this.setLastActivityTime(entryTime);
    }

    public void setLastActivityTime(Date lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public void setAverageFillPrice(double averageFillPrice) {
        this.averageFillPrice = averageFillPrice;
    }

    public int getInternalOrderId() {
        return this.internalOrderId;
    }

    public long getOrderIndex() {
        return this.orderIndex;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setServiceOrderId(String serviceOrderId) {
        this.serviceOrderId = serviceOrderId;
    }

    public String getServiceOrderId() {
        return this.serviceOrderId;
    }

    public Position getEntryOfPosition() {
        return this.entryOfPosition;
    }

    public void setEntryOfPosition(Position entryOfPosition) {
        this.entryOfPosition = entryOfPosition;
    }

    public Position getExitOfPosition() {
        return this.exitOfPosition;
    }

    public void setExitOfPosition(Position exitOfPosition) {
        this.exitOfPosition = exitOfPosition;
    }

    public void setExitOrder(boolean isExitOrder) {
        this.isExitOrder = isExitOrder;
    }

    public boolean isExitOrder() {
        return this.isExitOrder;
    }

    public Date getEntryTime() {
        return this.entryTime;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public OrderExpression getOrderExpression() {
        return this.orderExpression;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Date getLastActivityTime() {
        return this.lastActivityTime;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public double getAverageFillPrice() {
        return this.averageFillPrice;
    }

    public OHLCVItem getOhlcvItem() {
        return this.ohlcvItem;
    }

    public void setOhlcvItem(OHLCVItem ohlcvItem) {
        this.ohlcvItem = ohlcvItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.internalOrderId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return this.internalOrderId == other.internalOrderId;
    }

    public String toString() {
        return "Order [internalOrderId=" + this.internalOrderId + ", orderIndex=" + this.orderIndex + ", userName=" + this.userName + ", serviceOrderId=" + this.serviceOrderId + ", entryTime=" + this.entryTime + ", symbol=" + this.symbol + ", orderExpression=" + this.orderExpression + ", accountId=" + this.accountId + ", lastActivityTime=" + this.lastActivityTime + ", status=" + this.status + ", averageFillPrice=" + this.averageFillPrice + "]";
    }

    public static enum OrderStatus {
        OPENED,
        FILLED,
        CANCELLED,
        ERROR;

    }
}

