/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.dos;

import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.financial.samples.dos.OHLCVItemExtended;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OHLCVItem
implements IOhlcvItem {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private final Date timeStamp;
    private final double open;
    private final double high;
    private final double low;
    private final double close;
    private final double volume;
    private double volumeUp;
    private double volumeDown;
    private final double openInterest;
    private boolean gap;
    private OHLCVItemExtended extended;
    private AttributeModel addon;

    public OHLCVItem(Date timeStamp, double open, double high, double low, double close, double volume, double openInterest) {
        this.timeStamp = timeStamp;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
        this.openInterest = openInterest;
    }

    public OHLCVItem(Date timeStamp, double open, double high, double low, double close, double volume, double openInterest, double volumeUp, double volumeDown) {
        this.timeStamp = timeStamp;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
        this.openInterest = openInterest;
        this.volumeUp = volumeUp;
        this.volumeDown = volumeDown;
    }

    public void setAddon(AttributeModel addon) {
        this.addon = addon;
    }

    public AttributeModel getAddon() {
        return this.addon;
    }

    public AttributeModel getAddonOrCreate() {
        if (this.addon == null) {
            this.addon = new AttributeModel();
        }
        return this.addon;
    }

    public OHLCVItemExtended getExtended() {
        return this.extended;
    }

    public void setExtended(OHLCVItemExtended extended) {
        this.extended = extended;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public double getOpen() {
        return this.open;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getClose() {
        return this.close;
    }

    public double getVolume() {
        return this.volume;
    }

    public double getVolumeUpAsk() {
        return this.volumeUp;
    }

    public double getVolumeDownBid() {
        return this.volumeDown;
    }

    public double getOpenInterest() {
        return this.openInterest;
    }

    public boolean isGap() {
        return this.gap;
    }

    public void setGap(boolean gap) {
        this.gap = gap;
    }

    public String toString() {
        return "OHLCV [timeStamp=" + dateFormat.format(this.timeStamp) + ", open=" + this.open + ", high=" + this.high + ", low=" + this.low + ", close=" + this.close + ", volume=" + this.volume + ", bidVol=" + this.volumeDown + ", askVol=" + this.volumeUp + ", openInterest=" + this.openInterest + "]";
    }

    public String toStringShort() {
        return dateFormat.format(this.timeStamp) + ", " + this.open + ", " + this.high + ", " + this.low + ", " + this.close + ", V=" + this.volume + ", OI=" + this.openInterest + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.close);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.high);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.low);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.open);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.openInterest);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.timeStamp == null ? 0 : this.timeStamp.hashCode());
        temp = Double.doubleToLongBits(this.volume);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OHLCVItem other = (OHLCVItem)obj;
        if (Double.doubleToLongBits(this.close) != Double.doubleToLongBits(other.close)) {
            return false;
        }
        if (Double.doubleToLongBits(this.high) != Double.doubleToLongBits(other.high)) {
            return false;
        }
        if (Double.doubleToLongBits(this.low) != Double.doubleToLongBits(other.low)) {
            return false;
        }
        if (Double.doubleToLongBits(this.open) != Double.doubleToLongBits(other.open)) {
            return false;
        }
        if (Double.doubleToLongBits(this.openInterest) != Double.doubleToLongBits(other.openInterest)) {
            return false;
        }
        if (this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp)) {
            return false;
        }
        return Double.doubleToLongBits(this.volume) == Double.doubleToLongBits(other.volume);
    }
}

