/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.financial.CandleStickRenderer;
import de.gsi.chart.renderer.spi.financial.PositionFinancialRendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.financial.samples.AbstractBasicFinancialApplication;
import de.gsi.financial.samples.dos.Position;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.CalendarUtils;
import de.gsi.financial.samples.service.StandardTradePlanAttributes;
import de.gsi.financial.samples.service.order.PositionFinancialDataSet;
import java.text.ParseException;
import javafx.application.Application;

public class FinancialPositionSample
extends AbstractBasicFinancialApplication {
    @Override
    protected void prepareRenderers(XYChart chart, OhlcvDataSet ohlcvDataSet, DefaultDataSet indiSet) {
        AttributeModel context = new AttributeModel().setAttribute(StandardTradePlanAttributes.POSITIONS, (Object)new PositionContainer());
        this.addClosedPosition(context, 0, "2020/09/01 16:00", 3516.75, "2020/09/04 16:00", 3407.25, 1, 1, this.resource);
        this.addClosedPosition(context, 1, "2020/09/10 16:00", 3330.0, "2020/09/18 16:00", 3316.25, 1, -1, this.resource);
        this.addClosedPosition(context, 2, "2020/09/28 16:00", 3291.0, "2020/10/05 16:00", 3393.0, 1, 1, this.resource);
        this.addClosedPosition(context, 3, "2020/09/28 16:00", 3291.0, "2020/10/19 16:00", 3422.75, 1, 1, this.resource);
        PositionFinancialDataSet positionFinancialDataSet = new PositionFinancialDataSet(this.resource, ohlcvDataSet, context);
        CandleStickRenderer candleStickRenderer = new CandleStickRenderer();
        candleStickRenderer.getDatasets().addAll((Object[])new DataSet[]{ohlcvDataSet});
        candleStickRenderer.addPaintAfterEp((RendererPaintAfterEP)new PositionFinancialRendererPaintAfterEP((DataSet)positionFinancialDataSet, chart));
        ErrorDataSetRenderer avgRenderer = new ErrorDataSetRenderer();
        avgRenderer.setDrawMarker(false);
        avgRenderer.setErrorType(ErrorStyle.NONE);
        avgRenderer.getDatasets().addAll((Object[])new DataSet[]{indiSet});
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)candleStickRenderer);
        chart.getRenderers().add((Object)avgRenderer);
    }

    private void addClosedPosition(AttributeModel context, int id, String entryTimePattern, double entryPrice, String exitTimePattern, double exitPrice, int quantity, int longShort, String symbol) {
        try {
            ((PositionContainer)context.getRequiredAttribute(StandardTradePlanAttributes.POSITIONS)).addPosition(this.getClosedPosition(id, entryTimePattern, entryPrice, exitTimePattern, exitPrice, quantity, longShort, symbol));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The time pattern is not correctly configured! e=" + e.getMessage(), e);
        }
    }

    private Position getClosedPosition(int id, String entryTimePattern, double entryPrice, String exitTimePattern, double exitPrice, int quantity, int longShort, String symbol) throws ParseException {
        return this.closePosition(this.getOpenedPosition(id, entryTimePattern, entryPrice, quantity, longShort, symbol), exitTimePattern, exitPrice);
    }

    private Position getOpenedPosition(int id, String entryTimePattern, double entryPrice, int quantity, int longShort, String symbol) throws ParseException {
        return new Position(id, null, "strategy1", CalendarUtils.createByDateTime(entryTimePattern).getTime(), longShort, symbol, "account1", entryPrice, quantity);
    }

    private Position closePosition(Position position, String exitTimePattern, double exitPrice) throws ParseException {
        Position positionClosed = position.copyDeep();
        positionClosed.setExitTime(CalendarUtils.createByDateTime(exitTimePattern).getTime());
        positionClosed.setPositionExitIndex(positionClosed.getExitTime().getTime());
        positionClosed.setExitPrice(exitPrice);
        positionClosed.setPositionStatus(Position.PositionStatus.CLOSED);
        return positionClosed;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

