/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.financial.AbstractFinancialRenderer;
import de.gsi.chart.renderer.spi.financial.CandleStickRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.financial.OhlcvDataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeKey;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.financial.samples.AbstractBasicFinancialApplication;
import java.util.Calendar;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FinancialAdvancedCandlestickSample
extends AbstractBasicFinancialApplication {
    public static final AttributeKey<Boolean> MARK_BAR = AttributeKey.create(Boolean.class, (String)"MARK_BAR");

    @Override
    protected Scene prepareScene() {
        this.timeRange = "2020/06/24 0:00-2020/11/12 0:00";
        Chart chart = this.getDefaultFinancialTestChart("SAND");
        AbstractFinancialRenderer renderer = (AbstractFinancialRenderer)chart.getRenderers().get(0);
        ToolBar testVariableToolBar = this.getTestToolBar(chart, renderer, false);
        VBox root = new VBox();
        VBox.setVgrow((Node)chart, (Priority)Priority.SOMETIMES);
        root.getChildren().addAll((Object[])new Node[]{testVariableToolBar, chart});
        return new Scene((Parent)root, (double)this.prefSceneWidth, (double)this.prefSceneHeight);
    }

    @Override
    protected void prepareRenderers(XYChart chart, OhlcvDataSet ohlcvDataSet, DefaultDataSet indiSet) {
        CandleStickRenderer candleStickRenderer = new CandleStickRenderer(true);
        candleStickRenderer.getDatasets().addAll((Object[])new DataSet[]{ohlcvDataSet});
        ErrorDataSetRenderer avgRenderer = new ErrorDataSetRenderer();
        avgRenderer.setDrawMarker(false);
        avgRenderer.setErrorType(ErrorStyle.NONE);
        avgRenderer.getDatasets().addAll((Object[])new DataSet[]{indiSet});
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)candleStickRenderer);
        chart.getRenderers().add((Object)avgRenderer);
        candleStickRenderer.setPaintBarMarker(d -> d.ohlcvItem.getOpen() - d.ohlcvItem.getClose() > 100.0 ? Color.MAGENTA : null);
        Calendar cal = Calendar.getInstance();
        for (IOhlcvItem ohlcvItem : ohlcvDataSet) {
            cal.setTime(ohlcvItem.getTimeStamp());
            int day = cal.get(7);
            if (day != 6) continue;
            ohlcvItem.getAddonOrCreate().setAttribute(MARK_BAR, (Object)true);
        }
        candleStickRenderer.addPaintAfterEp(d -> {
            if (d.ohlcvItem.getAddon() != null && ((Boolean)d.ohlcvItem.getAddon().getAttribute(MARK_BAR, (Object)false)).booleanValue()) {
                double yy;
                if (d.ohlcvItem.getClose() > d.ohlcvItem.getOpen()) {
                    yy = d.yClose - (d.yClose - d.yOpen) / 2.0;
                    d.gc.setFill((Paint)Color.CRIMSON);
                } else {
                    yy = d.yOpen - (d.yOpen - d.yClose) / 2.0;
                    d.gc.setFill((Paint)Color.YELLOW);
                }
                double rectCorr = d.barWidthHalf / 2.0;
                d.gc.fillRect(d.xCenter - rectCorr, yy - rectCorr, rectCorr * 2.0, rectCorr * 2.0);
            }
        });
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

