/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.samples.legacy;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class DoubleDataSet
extends AbstractDataSet<DoubleDataSet>
implements EditableDataSet,
DataSet2D {
    private static final long serialVersionUID = 467969092912080826L;
    protected double[] xValues;
    protected double[] yValues;
    protected int dataMaxIndex;

    public DoubleDataSet(DataSet2D another) {
        this("");
        this.lock().writeLockGuard(() -> another.lock().writeLockGuard(() -> {
            this.setName(another.getName());
            this.set(another);
        }));
    }

    public DoubleDataSet(String name) {
        this(name, 0);
    }

    public DoubleDataSet(String name, double[] xValues, double[] yValues, int initalSize, boolean deepCopy) {
        this(name);
        AssertUtils.notNull((String)"X data", (Object)xValues);
        AssertUtils.notNull((String)"Y data", (Object)yValues);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, initalSize));
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yValues, (int)initalSize);
        if (deepCopy) {
            this.xValues = new double[this.dataMaxIndex];
            this.yValues = new double[this.dataMaxIndex];
            System.arraycopy(xValues, 0, this.xValues, 0, Math.min(xValues.length, initalSize));
            System.arraycopy(yValues, 0, this.yValues, 0, Math.min(yValues.length, initalSize));
        } else {
            this.xValues = xValues;
            this.yValues = yValues;
        }
    }

    public DoubleDataSet(String name, int initalSize) {
        super(name, 2);
        AssertUtils.gtEqThanZero((String)"initalSize", (int)initalSize);
        this.xValues = new double[initalSize];
        this.yValues = new double[initalSize];
        this.dataMaxIndex = 0;
    }

    public DoubleDataSet add(double x, double y) {
        return this.add(this.getDataCount(), x, y, null);
    }

    public DoubleDataSet add(double x, double y, String label) {
        return this.add(this.getDataCount(), x, y, label);
    }

    public DoubleDataSet add(double[] xValuesNew, double[] yValuesNew) {
        this.lock();
        AssertUtils.notNull((String)"X coordinates", (Object)xValuesNew);
        AssertUtils.notNull((String)"Y coordinates", (Object)yValuesNew);
        AssertUtils.equalDoubleArrays((double[])xValuesNew, (double[])yValuesNew);
        this.lock().writeLockGuard(() -> {
            int newLength = this.getDataCount() + xValuesNew.length;
            if (newLength > this.xValues.length) {
                double[] xValuesNewAlloc = new double[newLength];
                double[] yValuesNewAlloc = new double[newLength];
                System.arraycopy(this.xValues, 0, xValuesNewAlloc, 0, this.getDataCount());
                System.arraycopy(this.yValues, 0, yValuesNewAlloc, 0, this.getDataCount());
                this.xValues = xValuesNewAlloc;
                this.yValues = yValuesNewAlloc;
            }
            System.arraycopy(xValuesNew, 0, this.xValues, this.getDataCount(), xValuesNew.length);
            System.arraycopy(yValuesNew, 0, this.yValues, this.getDataCount(), xValuesNew.length);
            this.dataMaxIndex = Math.max(0, this.dataMaxIndex + xValuesNew.length);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this));
    }

    public DoubleDataSet add(int index, double ... newValues) {
        return this.add(index, newValues[0], newValues[1], null);
    }

    public DoubleDataSet add(int index, double x, double y, String label) {
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            int minArraySize = Math.min(this.xValues.length - 1, this.yValues.length - 1);
            if (this.dataMaxIndex > minArraySize) {
                double[] xValuesNew = new double[this.dataMaxIndex + 1];
                double[] yValuesNew = new double[this.dataMaxIndex + 1];
                System.arraycopy(this.xValues, 0, xValuesNew, 0, indexAt);
                System.arraycopy(this.yValues, 0, yValuesNew, 0, indexAt);
                System.arraycopy(this.xValues, indexAt, xValuesNew, indexAt + 1, this.xValues.length - indexAt);
                System.arraycopy(this.yValues, indexAt, yValuesNew, indexAt + 1, this.yValues.length - indexAt);
                for (int i = this.xValues.length; i >= indexAt; --i) {
                    String oldStyleData;
                    String oldLabelData = (String)this.getDataLabelMap().get((Object)i);
                    if (oldLabelData != null) {
                        this.getDataLabelMap().put((Object)(i + 1), (Object)oldLabelData);
                        this.getDataLabelMap().remove((Object)i);
                    }
                    if ((oldStyleData = (String)this.getDataStyleMap().get((Object)i)) == null) continue;
                    this.getDataStyleMap().put((Object)(i + 1), (Object)oldStyleData);
                    this.getDataStyleMap().remove((Object)i);
                }
                this.xValues = xValuesNew;
                this.yValues = yValuesNew;
            }
            this.xValues[indexAt] = x;
            this.yValues[indexAt] = y;
            if (label != null && !label.isEmpty()) {
                this.addDataLabel(indexAt, label);
            }
            ++this.dataMaxIndex;
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new AddedDataEvent((EventSource)this));
    }

    public DoubleDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.dataMaxIndex = 0;
            Arrays.fill(this.xValues, 0.0);
            Arrays.fill(this.yValues, 0.0);
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new RemovedDataEvent((EventSource)this, "clearData()"));
    }

    public double get(int dimImdex, int index) {
        return dimImdex == 0 ? this.xValues[index] : this.yValues[index];
    }

    public int getDataCount() {
        return Math.min(this.dataMaxIndex, this.xValues.length);
    }

    public double[] getXValues() {
        return this.xValues;
    }

    public double[] getYValues() {
        return this.yValues;
    }

    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds((int)fromIndex, (int)this.getDataCount(), (String)"fromIndex");
            AssertUtils.indexInBounds((int)toIndex, (int)this.getDataCount(), (String)"toIndex");
            AssertUtils.indexOrder((int)fromIndex, (String)"fromIndex", (int)toIndex, (String)"toIndex");
            int diffLength = toIndex - fromIndex;
            int newLength = this.xValues.length - diffLength;
            double[] xValuesNew = new double[newLength];
            double[] yValuesNew = new double[newLength];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, fromIndex);
            System.arraycopy(this.yValues, 0, yValuesNew, 0, fromIndex);
            System.arraycopy(this.xValues, toIndex, xValuesNew, fromIndex, newLength - fromIndex);
            System.arraycopy(this.yValues, toIndex, yValuesNew, fromIndex, newLength - fromIndex);
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
            for (int i = 0; i < diffLength; ++i) {
                String oldStyleData;
                String oldLabelData = (String)this.getDataLabelMap().get((Object)(toIndex + i));
                if (oldLabelData != null) {
                    this.getDataLabelMap().put((Object)(fromIndex + i), (Object)oldLabelData);
                    this.getDataLabelMap().remove((Object)(toIndex + i));
                }
                if ((oldStyleData = (String)this.getDataStyleMap().get((Object)(toIndex + i))) == null) continue;
                this.getDataStyleMap().put((Object)(fromIndex + i), (Object)oldStyleData);
                this.getDataStyleMap().remove((Object)(toIndex + i));
            }
            this.dataMaxIndex = Math.max(0, this.dataMaxIndex - diffLength);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new RemovedDataEvent((EventSource)this));
    }

    public DoubleDataSet set(DataSet2D other) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            int index;
            this.getDataLabelMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(other.getStyle());
            this.set(other.getXValues(), other.getYValues(), true);
        }));
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)this));
    }

    public DoubleDataSet set(double[] xValues, double[] yValues) {
        return this.set(xValues, yValues, true);
    }

    public DoubleDataSet set(double[] xValues, double[] yValues, boolean copy) {
        AssertUtils.notNull((String)"X coordinates", (Object)xValues);
        AssertUtils.notNull((String)"Y coordinates", (Object)yValues);
        AssertUtils.equalDoubleArrays((double[])xValues, (double[])yValues);
        this.lock().writeLockGuard(() -> {
            if (!copy) {
                this.xValues = xValues;
                this.yValues = yValues;
                this.dataMaxIndex = xValues.length;
                this.recomputeLimits(0);
                this.recomputeLimits(1);
                return;
            }
            if (xValues.length == this.xValues.length) {
                System.arraycopy(xValues, 0, this.xValues, 0, this.getDataCount());
                System.arraycopy(yValues, 0, this.yValues, 0, this.getDataCount());
            } else {
                this.xValues = Arrays.copyOf(xValues, xValues.length);
                this.yValues = Arrays.copyOf(yValues, xValues.length);
            }
            this.dataMaxIndex = xValues.length;
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)this));
    }

    public DoubleDataSet set(int index, double ... newValue) {
        this.lock().writeLockGuard(() -> {
            this.xValues[index] = newValue[0];
            this.yValues[index] = newValue[1];
            this.dataMaxIndex = Math.max(index, this.dataMaxIndex);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleDataSet)this.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)this));
    }

    public EditableDataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("Copy setter not implemented");
    }
}

